/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpCompression;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.web.runtime.HttpCompressionHandler;
import io.quarkus.vertx.web.runtime.RouteHandler;
import io.quarkus.vertx.web.runtime.RouteMatcher;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

@Recorder
public class VertxWebRecorder {
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final HttpBuildTimeConfig httpBuildTimeConfig;

    public VertxWebRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, HttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
    }

    public Handler<RoutingContext> createHandler(String handlerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxWebRecorder.class.getClassLoader();
            }
            Class<?> handlerClazz = cl.loadClass(handlerClassName);
            RouteHandler handler = (RouteHandler)handlerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return handler;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create route handler: " + handlerClassName, e);
        }
    }

    public Handler<RoutingContext> compressRouteHandler(Handler<RoutingContext> routeHandler, HttpCompression compression) {
        if (this.httpBuildTimeConfig.enableCompression) {
            return new HttpCompressionHandler(routeHandler, compression, compression == HttpCompression.UNDEFINED ? Set.copyOf(this.httpBuildTimeConfig.compressMediaTypes.orElse(List.of())) : Set.of());
        }
        return routeHandler;
    }

    public Function<Router, Route> createRouteFunction(final RouteMatcher matcher, final Handler<RoutingContext> bodyHandler, final boolean alwaysAuthenticateRoute) {
        return new Function<Router, Route>(){

            @Override
            public Route apply(Router router) {
                Route route = matcher.getRegex() != null && !matcher.getRegex().isEmpty() ? router.routeWithRegex(matcher.getRegex()) : (matcher.getPath() != null && !matcher.getPath().isEmpty() ? router.route(matcher.getPath()) : router.route());
                if (matcher.getMethods().length > 0) {
                    for (String method : matcher.getMethods()) {
                        route.method(HttpMethod.valueOf((String)method));
                    }
                }
                if (matcher.getOrder() > 0) {
                    route.order(matcher.getOrder());
                }
                if (matcher.getProduces().length > 0) {
                    for (String produces : matcher.getProduces()) {
                        route.produces(produces);
                    }
                }
                if (matcher.getConsumes().length > 0) {
                    for (String consumes : matcher.getConsumes()) {
                        route.consumes(consumes);
                    }
                }
                if (alwaysAuthenticateRoute) {
                    route = route.handler(routingContext -> {
                        if (routingContext.user() == null) {
                            ((Uni)routingContext.get("io.quarkus.vertx.http.deferred-identity")).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

                                public void onSubscribe(UniSubscription subscription) {
                                }

                                public void onItem(Object item) {
                                    if (routingContext.response().ended()) {
                                        return;
                                    }
                                    routingContext.next();
                                }

                                public void onFailure(Throwable failure) {
                                    BiConsumer handler = (BiConsumer)routingContext.get("io.quarkus.vertx.http.auth-failure-handler");
                                    if (handler != null) {
                                        handler.accept(routingContext, failure);
                                    }
                                }
                            });
                        }
                    });
                }
                if (bodyHandler != null) {
                    route.handler(bodyHandler);
                }
                return route;
            }
        };
    }
}

