/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SummarizeArgs
implements RedisCommandExtraArguments {
    private String[] fields;
    private int frags;
    private int len;
    private String separator;

    public SummarizeArgs fields(String ... fields) {
        this.fields = (String[])ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(fields, "fields"), (String)"fields");
        return this;
    }

    public SummarizeArgs fragments(int fragments) {
        ParameterValidation.positive((int)fragments, (String)"fragments");
        this.frags = fragments;
        return this;
    }

    public SummarizeArgs length(int length) {
        ParameterValidation.positive((int)length, (String)"length");
        this.len = length;
        return this;
    }

    public SummarizeArgs separator(String separator) {
        Validation.notNullOrBlank(separator, "separator");
        this.separator = separator;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SUMMARIZE");
        if (this.fields != null && this.fields.length > 0) {
            list.add("FIELDS");
            list.add(Integer.toString(this.fields.length));
            list.addAll(Arrays.asList(this.fields));
        }
        if (this.frags > 0) {
            list.add("FRAGS");
            list.add(Integer.toString(this.frags));
        }
        if (this.len > 0) {
            list.add("LEN");
            list.add(Integer.toString(this.len));
        }
        if (this.separator != null) {
            list.add("SEPARATOR");
            list.add(this.separator);
        }
        return list;
    }
}

