/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.autosuggest.GetArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;

public class AbstractAutoSuggestCommands<K>
extends AbstractRedisCommands {
    AbstractAutoSuggestCommands(RedisCommandExecutor redis, Class<K> k) {
        super(redis, new Marshaller(k));
    }

    Uni<Response> _ftSugAdd(K key, String string, double score, boolean increment) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(string, "string");
        RedisCommand cmd = RedisCommand.of(Command.FT_SUGADD).put(this.marshaller.encode(key)).put(string).put(score);
        if (increment) {
            cmd.put("INCR");
        }
        return this.execute(cmd);
    }

    Uni<Response> _ftSugDel(K key, String string) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(string, "string");
        RedisCommand cmd = RedisCommand.of(Command.FT_SUGDEL).put(this.marshaller.encode(key)).put(string);
        return this.execute(cmd);
    }

    Uni<Response> _ftSugget(K key, String prefix) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(prefix, "prefix");
        RedisCommand cmd = RedisCommand.of(Command.FT_SUGGET).put(this.marshaller.encode(key)).put(prefix);
        return this.execute(cmd);
    }

    Uni<Response> _ftSugget(K key, String prefix, GetArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrBlank(prefix, "prefix");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.FT_SUGGET).put(this.marshaller.encode(key)).put(prefix).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _ftSugLen(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.FT_SUGLEN).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }
}

