/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.bitmap.BitFieldArgs;
import io.quarkus.redis.datasource.bitmap.BitMapCommands;
import io.quarkus.redis.datasource.bitmap.ReactiveBitMapCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;

public class BlockingBitmapCommandsImpl<K>
extends AbstractRedisCommandGroup
implements BitMapCommands<K> {
    private final ReactiveBitMapCommands<K> reactive;

    public BlockingBitmapCommandsImpl(RedisDataSource ds, ReactiveBitMapCommands<K> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public int setbit(K key, long offset, int value) {
        return (Integer)this.reactive.setbit(key, offset, value).await().atMost(this.timeout);
    }

    @Override
    public long bitcount(K key) {
        return (Long)this.reactive.bitcount(key).await().atMost(this.timeout);
    }

    @Override
    public long bitcount(K key, long start, long end) {
        return (Long)this.reactive.bitcount(key, start, end).await().atMost(this.timeout);
    }

    @Override
    public List<Long> bitfield(K key, BitFieldArgs bitFieldArgs) {
        return (List)this.reactive.bitfield(key, bitFieldArgs).await().atMost(this.timeout);
    }

    @Override
    public long bitpos(K key, int bit) {
        return (Long)this.reactive.bitpos(key, bit).await().atMost(this.timeout);
    }

    @Override
    public long bitpos(K key, int bit, long start) {
        return (Long)this.reactive.bitpos(key, bit, start).await().atMost(this.timeout);
    }

    @Override
    public long bitpos(K key, int bit, long start, long end) {
        return (Long)this.reactive.bitpos(key, bit, start, end).await().atMost(this.timeout);
    }

    @Override
    public long bitopAnd(K destination, K ... keys) {
        return (Long)this.reactive.bitopAnd(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public long bitopNot(K destination, K source) {
        return (Long)this.reactive.bitopNot(destination, source).await().atMost(this.timeout);
    }

    @Override
    public long bitopOr(K destination, K ... keys) {
        return (Long)this.reactive.bitopOr(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public long bitopXor(K destination, K ... keys) {
        return (Long)this.reactive.bitopXor(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public int getbit(K key, long offset) {
        return (Integer)this.reactive.getbit(key, offset).await().atMost(this.timeout);
    }
}

