/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.keys.CopyArgs;
import io.quarkus.redis.datasource.keys.ExpireArgs;
import io.quarkus.redis.datasource.keys.KeyScanArgs;
import io.quarkus.redis.datasource.keys.ReactiveKeyCommands;
import io.quarkus.redis.datasource.keys.ReactiveKeyScanCursor;
import io.quarkus.redis.datasource.keys.RedisValueType;
import io.quarkus.redis.runtime.datasource.AbstractKeyCommands;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.ScanReactiveCursorImpl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Response;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;

public class ReactiveKeyCommandsImpl<K>
extends AbstractKeyCommands<K>
implements ReactiveKeyCommands<K> {
    private final ReactiveRedisDataSource reactive;

    public ReactiveKeyCommandsImpl(ReactiveRedisDataSourceImpl redis, Class<K> k) {
        super((RedisCommandExecutor)redis, k);
        this.reactive = redis;
    }

    @Override
    public ReactiveRedisDataSource getDataSource() {
        return this.reactive;
    }

    @Override
    public Uni<Boolean> copy(K source, K destination) {
        return super._copy(source, destination).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> copy(K source, K destination, CopyArgs copyArgs) {
        return super._copy(source, destination, copyArgs).map(Response::toBoolean);
    }

    @Override
    public Uni<Integer> del(K ... keys) {
        return super._del(keys).map(Response::toInteger);
    }

    @Override
    public Uni<String> dump(K key) {
        return super._dump(key).map(this::decodeStringOrNull);
    }

    @Override
    public Uni<Boolean> exists(K key) {
        return super._exists(key).map(Response::toBoolean);
    }

    @Override
    public Uni<Integer> exists(K ... keys) {
        return super._exists(keys).map(Response::toInteger);
    }

    @Override
    public Uni<Boolean> expire(K key, long seconds, ExpireArgs expireArgs) {
        return super._expire(key, seconds, expireArgs).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> expire(K key, Duration duration, ExpireArgs expireArgs) {
        return this.expire(key, duration.toSeconds(), expireArgs);
    }

    @Override
    public Uni<Boolean> expire(K key, long seconds) {
        return this.expire(key, seconds, new ExpireArgs());
    }

    @Override
    public Uni<Boolean> expire(K key, Duration duration) {
        return this.expire(key, duration.toSeconds(), new ExpireArgs());
    }

    @Override
    public Uni<Boolean> expireat(K key, long timestamp) {
        return this.expireat(key, timestamp, new ExpireArgs());
    }

    @Override
    public Uni<Boolean> expireat(K key, Instant timestamp) {
        return this.expireat(key, timestamp.getEpochSecond(), new ExpireArgs());
    }

    @Override
    public Uni<Boolean> expireat(K key, long timestamp, ExpireArgs expireArgs) {
        return super._expireat(key, timestamp, expireArgs).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        return this.expireat(key, timestamp.getEpochSecond(), expireArgs);
    }

    @Override
    public Uni<Long> expiretime(K key) {
        return super._expiretime(key).map(r -> this.decodeExpireResponse(key, (Response)r));
    }

    @Override
    public Uni<List<K>> keys(String pattern) {
        return super._keys(pattern).map(this::decodeKeys);
    }

    @Override
    public Uni<Boolean> move(K key, long db) {
        return super._move(key, db).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> persist(K key) {
        return super._persist(key).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        return super._pexpire(key, milliseconds, expireArgs).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> pexpire(K key, Duration duration, ExpireArgs expireArgs) {
        return this.pexpire(key, duration.toMillis(), expireArgs);
    }

    @Override
    public Uni<Boolean> pexpire(K key, long ms) {
        return this.pexpire(key, ms, new ExpireArgs());
    }

    @Override
    public Uni<Boolean> pexpire(K key, Duration duration) {
        return this.pexpire(key, duration.toMillis(), new ExpireArgs());
    }

    @Override
    public Uni<Boolean> pexpireat(K key, long timestamp) {
        return this.pexpireat(key, timestamp, new ExpireArgs());
    }

    @Override
    public Uni<Boolean> pexpireat(K key, Instant timestamp) {
        return this.pexpireat(key, timestamp.toEpochMilli(), new ExpireArgs());
    }

    @Override
    public Uni<Boolean> pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        return super._pexpireat(key, timestamp, expireArgs).map(Response::toBoolean);
    }

    @Override
    public Uni<Boolean> pexpireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        return this.pexpireat(key, timestamp.toEpochMilli(), expireArgs);
    }

    @Override
    public Uni<Long> pexpiretime(K key) {
        return super._pexpiretime(key).map(r -> this.decodeExpireResponse(key, (Response)r));
    }

    @Override
    public Uni<Long> pttl(K key) {
        return super._pttl(key).map(r -> this.decodeExpireResponse(key, (Response)r));
    }

    @Override
    public Uni<K> randomkey() {
        return super._randomkey().map(this::decodeK);
    }

    @Override
    public Uni<Void> rename(K key, K newKey) {
        return super._rename(key, newKey).replaceWithVoid();
    }

    @Override
    public Uni<Boolean> renamenx(K key, K newKey) {
        return super._renamenx(key, newKey).map(Response::toBoolean);
    }

    @Override
    public ReactiveKeyScanCursor<K> scan() {
        return new ScanReactiveCursorImpl(this.redis, this.marshaller, this.typeOfKey, Collections.emptyList());
    }

    @Override
    public ReactiveKeyScanCursor<K> scan(KeyScanArgs args) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        return new ScanReactiveCursorImpl(this.redis, this.marshaller, this.typeOfKey, args.toArgs());
    }

    @Override
    public Uni<Integer> touch(K ... keys) {
        return super._touch(keys).map(Response::toInteger);
    }

    @Override
    public Uni<Long> ttl(K key) {
        return super._ttl(key).map(r -> this.decodeExpireResponse(key, (Response)r));
    }

    @Override
    public Uni<RedisValueType> type(K key) {
        return super._type(key).map(this::decodeRedisType);
    }

    @Override
    public Uni<Integer> unlink(K ... keys) {
        return super._unlink(keys).map(Response::toInteger);
    }
}

