/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.autosuggest.AutoSuggestCommands;
import io.quarkus.redis.datasource.bitmap.BitMapCommands;
import io.quarkus.redis.datasource.bloom.BloomCommands;
import io.quarkus.redis.datasource.countmin.CountMinCommands;
import io.quarkus.redis.datasource.cuckoo.CuckooCommands;
import io.quarkus.redis.datasource.geo.GeoCommands;
import io.quarkus.redis.datasource.graph.GraphCommands;
import io.quarkus.redis.datasource.hash.HashCommands;
import io.quarkus.redis.datasource.hyperloglog.HyperLogLogCommands;
import io.quarkus.redis.datasource.json.JsonCommands;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.list.ListCommands;
import io.quarkus.redis.datasource.pubsub.PubSubCommands;
import io.quarkus.redis.datasource.search.SearchCommands;
import io.quarkus.redis.datasource.set.SetCommands;
import io.quarkus.redis.datasource.sortedset.SortedSetCommands;
import io.quarkus.redis.datasource.stream.StreamCommands;
import io.quarkus.redis.datasource.string.StringCommands;
import io.quarkus.redis.datasource.timeseries.TimeSeriesCommands;
import io.quarkus.redis.datasource.topk.TopKCommands;
import io.quarkus.redis.datasource.transactions.OptimisticLockingTransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.datasource.value.ValueCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.smallrye.common.annotation.Experimental;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.Command;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface RedisDataSource {
    public void withConnection(Consumer<RedisDataSource> var1);

    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> var1);

    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> var1, String ... var2);

    public <I> OptimisticLockingTransactionResult<I> withTransaction(Function<RedisDataSource, I> var1, BiConsumer<I, TransactionalRedisDataSource> var2, String ... var3);

    public void select(long var1);

    public void flushall();

    public <K, F, V> HashCommands<K, F, V> hash(Class<K> var1, Class<F> var2, Class<V> var3);

    public <K, F, V> HashCommands<K, F, V> hash(TypeReference<K> var1, TypeReference<F> var2, TypeReference<V> var3);

    default public <V> HashCommands<String, String, V> hash(Class<V> typeOfValue) {
        return this.hash(String.class, String.class, typeOfValue);
    }

    default public <V> HashCommands<String, String, V> hash(TypeReference<V> typeOfValue) {
        return this.hash(Marshaller.STRING_TYPE_REFERENCE, Marshaller.STRING_TYPE_REFERENCE, typeOfValue);
    }

    public <K, V> GeoCommands<K, V> geo(Class<K> var1, Class<V> var2);

    public <K, V> GeoCommands<K, V> geo(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> GeoCommands<String, V> geo(Class<V> memberType) {
        return this.geo(String.class, memberType);
    }

    default public <V> GeoCommands<String, V> geo(TypeReference<V> memberType) {
        return this.geo(Marshaller.STRING_TYPE_REFERENCE, memberType);
    }

    public <K> KeyCommands<K> key(Class<K> var1);

    public <K> KeyCommands<K> key(TypeReference<K> var1);

    default public KeyCommands<String> key() {
        return this.key(String.class);
    }

    public <K, V> SortedSetCommands<K, V> sortedSet(Class<K> var1, Class<V> var2);

    public <K, V> SortedSetCommands<K, V> sortedSet(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> SortedSetCommands<String, V> sortedSet(Class<V> valueType) {
        return this.sortedSet(String.class, valueType);
    }

    default public <V> SortedSetCommands<String, V> sortedSet(TypeReference<V> valueType) {
        return this.sortedSet(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    public <K, V> ValueCommands<K, V> value(Class<K> var1, Class<V> var2);

    public <K, V> ValueCommands<K, V> value(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> ValueCommands<String, V> value(Class<V> valueType) {
        return this.value(String.class, valueType);
    }

    default public <V> ValueCommands<String, V> value(TypeReference<V> valueType) {
        return this.value(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    @Deprecated
    public <K, V> StringCommands<K, V> string(Class<K> var1, Class<V> var2);

    @Deprecated
    default public <V> StringCommands<String, V> string(Class<V> valueType) {
        return this.string(String.class, valueType);
    }

    public <K, V> SetCommands<K, V> set(Class<K> var1, Class<V> var2);

    public <K, V> SetCommands<K, V> set(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> SetCommands<String, V> set(Class<V> memberType) {
        return this.set(String.class, memberType);
    }

    default public <V> SetCommands<String, V> set(TypeReference<V> memberType) {
        return this.set(Marshaller.STRING_TYPE_REFERENCE, memberType);
    }

    public <K, V> ListCommands<K, V> list(Class<K> var1, Class<V> var2);

    default public <V> ListCommands<String, V> list(Class<V> memberType) {
        return this.list(String.class, memberType);
    }

    public <K, V> ListCommands<K, V> list(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> ListCommands<String, V> list(TypeReference<V> memberType) {
        return this.list(Marshaller.STRING_TYPE_REFERENCE, memberType);
    }

    public <K, V> HyperLogLogCommands<K, V> hyperloglog(Class<K> var1, Class<V> var2);

    public <K, V> HyperLogLogCommands<K, V> hyperloglog(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> HyperLogLogCommands<String, V> hyperloglog(Class<V> memberType) {
        return this.hyperloglog(String.class, memberType);
    }

    default public <V> HyperLogLogCommands<String, V> hyperloglog(TypeReference<V> memberType) {
        return this.hyperloglog(Marshaller.STRING_TYPE_REFERENCE, memberType);
    }

    public <K> BitMapCommands<K> bitmap(Class<K> var1);

    public <K> BitMapCommands<K> bitmap(TypeReference<K> var1);

    default public BitMapCommands<String> bitmap() {
        return this.bitmap(String.class);
    }

    public <K, F, V> StreamCommands<K, F, V> stream(Class<K> var1, Class<F> var2, Class<V> var3);

    public <K, F, V> StreamCommands<K, F, V> stream(TypeReference<K> var1, TypeReference<F> var2, TypeReference<V> var3);

    default public <V> StreamCommands<String, String, V> stream(Class<V> typeOfValue) {
        return this.stream(String.class, String.class, typeOfValue);
    }

    default public <V> StreamCommands<String, String, V> stream(TypeReference<V> typeOfValue) {
        return this.stream(Marshaller.STRING_TYPE_REFERENCE, Marshaller.STRING_TYPE_REFERENCE, typeOfValue);
    }

    default public JsonCommands<String> json() {
        return this.json(String.class);
    }

    public <K> JsonCommands<K> json(Class<K> var1);

    public <K> JsonCommands<K> json(TypeReference<K> var1);

    default public <V> BloomCommands<String, V> bloom(Class<V> valueType) {
        return this.bloom(String.class, valueType);
    }

    default public <V> BloomCommands<String, V> bloom(TypeReference<V> valueType) {
        return this.bloom(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    public <K, V> BloomCommands<K, V> bloom(Class<K> var1, Class<V> var2);

    public <K, V> BloomCommands<K, V> bloom(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> CuckooCommands<String, V> cuckoo(Class<V> valueType) {
        return this.cuckoo(String.class, valueType);
    }

    default public <V> CuckooCommands<String, V> cuckoo(TypeReference<V> valueType) {
        return this.cuckoo(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    public <K, V> CuckooCommands<K, V> cuckoo(Class<K> var1, Class<V> var2);

    public <K, V> CuckooCommands<K, V> cuckoo(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> CountMinCommands<String, V> countmin(Class<V> valueType) {
        return this.countmin(String.class, valueType);
    }

    default public <V> CountMinCommands<String, V> countmin(TypeReference<V> valueType) {
        return this.countmin(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    public <K, V> CountMinCommands<K, V> countmin(Class<K> var1, Class<V> var2);

    public <K, V> CountMinCommands<K, V> countmin(TypeReference<K> var1, TypeReference<V> var2);

    default public <V> TopKCommands<String, V> topk(Class<V> valueType) {
        return this.topk(String.class, valueType);
    }

    default public <V> TopKCommands<String, V> topk(TypeReference<V> valueType) {
        return this.topk(Marshaller.STRING_TYPE_REFERENCE, valueType);
    }

    public <K, V> TopKCommands<K, V> topk(Class<K> var1, Class<V> var2);

    public <K, V> TopKCommands<K, V> topk(TypeReference<K> var1, TypeReference<V> var2);

    @Experimental(value="The Redis graph support is experimental, in addition, the graph module EOL")
    default public GraphCommands<String> graph() {
        return this.graph(String.class);
    }

    @Experimental(value="The Redis graph support is experimental, in addition, the graph module EOL")
    public <K> GraphCommands<K> graph(Class<K> var1);

    @Experimental(value="The Redis search support is experimental")
    @Deprecated
    public <K> SearchCommands<K> search(Class<K> var1);

    @Experimental(value="The Redis Search support is experimental")
    default public SearchCommands<String> search() {
        return this.search(String.class);
    }

    @Experimental(value="The Redis auto-suggest support is experimental")
    public <K> AutoSuggestCommands<K> autosuggest(Class<K> var1);

    @Experimental(value="The Redis auto-suggest support is experimental")
    public <K> AutoSuggestCommands<K> autosuggest(TypeReference<K> var1);

    @Experimental(value="The Redis auto-suggest support is experimental")
    default public AutoSuggestCommands<String> autosuggest() {
        return this.autosuggest(String.class);
    }

    @Experimental(value="The Redis time series support is experimental")
    public <K> TimeSeriesCommands<K> timeseries(Class<K> var1);

    @Experimental(value="The Redis time series support is experimental")
    public <K> TimeSeriesCommands<K> timeseries(TypeReference<K> var1);

    @Experimental(value="The Redis time series support is experimental")
    default public TimeSeriesCommands<String> timeseries() {
        return this.timeseries(String.class);
    }

    public <V> PubSubCommands<V> pubsub(Class<V> var1);

    public <V> PubSubCommands<V> pubsub(TypeReference<V> var1);

    public Response execute(String var1, String ... var2);

    public Response execute(io.vertx.mutiny.redis.client.Command var1, String ... var2);

    public Response execute(Command var1, String ... var2);

    public ReactiveRedisDataSource getReactive();
}

