/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.topk.ReactiveTransactionalTopKCommands;
import io.quarkus.redis.datasource.topk.TransactionalTopKCommands;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.AbstractTransactionalRedisCommandGroup;
import java.time.Duration;
import java.util.Map;

public class BlockingTransactionalTopKCommandsImpl<K, V>
extends AbstractTransactionalRedisCommandGroup
implements TransactionalTopKCommands<K, V> {
    private final ReactiveTransactionalTopKCommands<K, V> reactive;

    public BlockingTransactionalTopKCommandsImpl(TransactionalRedisDataSource ds, ReactiveTransactionalTopKCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void topkAdd(K key, V item) {
        this.reactive.topkAdd(key, item).await().atMost(this.timeout);
    }

    @Override
    public void topkAdd(K key, V ... items) {
        this.reactive.topkAdd(key, items).await().atMost(this.timeout);
    }

    @Override
    public void topkIncrBy(K key, V item, int increment) {
        this.reactive.topkIncrBy(key, item, increment).await().atMost(this.timeout);
    }

    @Override
    public void topkIncrBy(K key, Map<V, Integer> couples) {
        this.reactive.topkIncrBy(key, couples).await().atMost(this.timeout);
    }

    @Override
    public void topkList(K key) {
        this.reactive.topkList(key).await().atMost(this.timeout);
    }

    @Override
    public void topkListWithCount(K key) {
        this.reactive.topkListWithCount(key).await().atMost(this.timeout);
    }

    @Override
    public void topkQuery(K key, V item) {
        this.reactive.topkQuery(key, item).await().atMost(this.timeout);
    }

    @Override
    public void topkQuery(K key, V ... items) {
        this.reactive.topkQuery(key, items).await().atMost(this.timeout);
    }

    @Override
    public void topkReserve(K key, int topk) {
        this.reactive.topkReserve(key, topk).await().atMost(this.timeout);
    }

    @Override
    public void topkReserve(K key, int topk, int width, int depth, double decay) {
        this.reactive.topkReserve(key, topk, width, depth, decay).await().atMost(this.timeout);
    }
}

