/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.JacksonUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientMessageBodyReader;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;

public class ClientJacksonMessageBodyReader
extends AbstractJsonMessageBodyReader
implements ClientMessageBodyReader<Object> {
    private static final Logger log = Logger.getLogger(ClientJacksonMessageBodyReader.class);
    private final ConcurrentMap<ObjectMapper, ObjectReader> objectReaderMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();
    private final ObjectReader defaultReader;

    @Inject
    public ClientJacksonMessageBodyReader(ObjectMapper mapper) {
        this.defaultReader = mapper.reader();
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.doRead(type, genericType, mediaType, annotations, entityStream, null);
    }

    private Object doRead(Class<Object> type, Type genericType, MediaType mediaType, Annotation[] annotations, InputStream entityStream, RestClientRequestContext context) throws IOException {
        try {
            if (entityStream instanceof EmptyInputStream) {
                return null;
            }
            ObjectReader reader = this.getEffectiveReader(mediaType, annotations, context);
            return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
        catch (JsonParseException e) {
            log.debug((Object)"Server returned invalid json data", (Throwable)e);
            throw new ClientWebApplicationException((Throwable)e, Response.Status.OK);
        }
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream, RestClientRequestContext context) throws IOException, WebApplicationException {
        return this.doRead(type, genericType, mediaType, annotations, entityStream, context);
    }

    private ObjectReader getEffectiveReader(MediaType responseMediaType, Annotation[] annotations, RestClientRequestContext context) {
        ObjectMapper effectiveMapper = JacksonUtil.getObjectMapperFromContext(responseMediaType, context);
        if (effectiveMapper == null) {
            return this.defaultReader;
        }
        return ClientJacksonMessageBodyReader.applyJsonViewIfPresent(this.objectReaderMap.computeIfAbsent(effectiveMapper, new Function<ObjectMapper, ObjectReader>(){

            @Override
            public ObjectReader apply(ObjectMapper objectMapper) {
                return objectMapper.reader();
            }
        }), annotations);
    }

    private static ObjectReader applyJsonViewIfPresent(ObjectReader reader, Annotation[] annotations) {
        Optional<Class<?>> maybeView = JacksonUtil.matchingView(annotations);
        if (maybeView.isPresent()) {
            return reader.withView(maybeView.get());
        }
        return reader;
    }
}

