/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;

public class ClientJacksonMessageBodyReader
extends JacksonBasicMessageBodyReader
implements ClientRestHandler {
    private final ConcurrentMap<ObjectMapper, ObjectReader> contextResolverMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();
    private RestClientRequestContext context;

    @Inject
    public ClientJacksonMessageBodyReader(ObjectMapper mapper) {
        super(mapper);
    }

    public void handle(RestClientRequestContext requestContext) {
        this.context = requestContext;
    }

    protected ObjectReader getEffectiveReader() {
        if (this.context == null) {
            return super.getEffectiveReader();
        }
        ObjectMapper objectMapper = (ObjectMapper)this.context.getConfiguration().getFromContext(ObjectMapper.class);
        if (objectMapper == null) {
            return super.getEffectiveReader();
        }
        return this.contextResolverMap.computeIfAbsent(objectMapper, new Function<ObjectMapper, ObjectReader>(){

            @Override
            public ObjectReader apply(ObjectMapper objectMapper) {
                return objectMapper.reader();
            }
        });
    }
}

