/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.rest.client.reactive.runtime.AnnotationRegisteredProviders;
import io.quarkus.rest.client.reactive.runtime.BeanGrabber;
import io.quarkus.rest.client.reactive.runtime.DefaultMicroprofileRestClientExceptionMapper;
import io.quarkus.rest.client.reactive.runtime.MicroProfileRestClientResponseFilter;
import io.quarkus.rest.client.reactive.runtime.RestClientListeners;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.reactive.client.api.InvalidRestClientDefinitionException;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.MultiQueryParamMode;

public class RestClientBuilderImpl
implements RestClientBuilder {
    private static final String DEFAULT_MAPPER_DISABLED = "microprofile.rest.client.disable.default.mapper";
    private static final String TLS_TRUST_ALL = "quarkus.tls.trust-all";
    private final ClientBuilderImpl clientBuilder = (ClientBuilderImpl)new ClientBuilderImpl().withConfig((Configuration)new ConfigurationImpl(RuntimeType.CLIENT));
    private final List<ResponseExceptionMapper<?>> exceptionMappers = new ArrayList();
    private URI uri;
    private boolean followRedirects;
    private QueryParamStyle queryParamStyle;

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert REST client URL to URI", e);
        }
        return this;
    }

    public RestClientBuilder connectTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.connectTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilder readTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.readTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.clientBuilder.sslContext(sslContext);
        return this;
    }

    public RestClientBuilder trustStore(KeyStore trustStore) {
        this.clientBuilder.trustStore(trustStore);
        return this;
    }

    public RestClientBuilder keyStore(KeyStore keyStore, String keystorePassword) {
        this.clientBuilder.keyStore(keyStore, keystorePassword);
        return this;
    }

    public RestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.clientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClientBuilder followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public RestClientBuilder proxyAddress(String proxyHost, int proxyPort) {
        if (proxyHost == null) {
            throw new IllegalArgumentException("proxyHost must not be null");
        }
        if (proxyPort <= 0 || proxyPort > 65535) {
            throw new IllegalArgumentException("Invalid port number");
        }
        this.clientBuilder.proxy(proxyHost, proxyPort);
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        throw new IllegalArgumentException("Specifying executor service is not supported. The underlying call in RestEasy Reactive is non-blocking, there is no reason to offload the call to a separate thread pool.");
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public RestClientBuilder property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass) {
        Object bean = BeanGrabber.getBeanIfDefined(componentClass);
        if (bean != null) {
            this.registerMpSpecificProvider(bean);
            this.clientBuilder.register(bean);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, int priority) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), priority);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, priority);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), (Class[])contracts);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, (Class[])contracts);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), contracts);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, contracts);
        }
        return this;
    }

    public RestClientBuilder register(Object component) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component);
        return this;
    }

    public RestClientBuilder register(Object component, int priority) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, priority);
        return this;
    }

    public RestClientBuilder register(Object component, Class<?> ... contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, contracts);
        return this;
    }

    public RestClientBuilder baseUri(URI uri) {
        this.uri = uri;
        return this;
    }

    private void registerMpSpecificProvider(Class<?> componentClass) {
        if (ResponseExceptionMapper.class.isAssignableFrom(componentClass)) {
            try {
                this.registerMpSpecificProvider(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to instantiate exception mapper " + componentClass + ". Does it have a public no-arg constructor?", e);
            }
        }
    }

    private void registerMpSpecificProvider(Object component) {
        if (component instanceof ResponseExceptionMapper) {
            this.exceptionMappers.add((ResponseExceptionMapper)component);
        }
    }

    public RestClientBuilder queryParamStyle(QueryParamStyle style) {
        this.queryParamStyle = style;
        return this;
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        if (this.uri == null) {
            throw new IllegalStateException("No URL specified. Cannot build a rest client without URL");
        }
        RestClientListeners.get().forEach(listener -> listener.onNewClient(aClass, (RestClientBuilder)this));
        AnnotationRegisteredProviders annotationRegisteredProviders = (AnnotationRegisteredProviders)Arc.container().instance(AnnotationRegisteredProviders.class, new Annotation[0]).get();
        for (Map.Entry<Class<?>, Integer> mapper : annotationRegisteredProviders.getProviders(aClass).entrySet()) {
            this.register(mapper.getKey(), (int)mapper.getValue());
        }
        Object defaultMapperDisabled = this.getConfiguration().getProperty(DEFAULT_MAPPER_DISABLED);
        Boolean globallyDisabledMapper = ConfigProvider.getConfig().getOptionalValue(DEFAULT_MAPPER_DISABLED, Boolean.class).orElse(false);
        if (!(globallyDisabledMapper.booleanValue() || defaultMapperDisabled instanceof Boolean && ((Boolean)defaultMapperDisabled).booleanValue())) {
            this.exceptionMappers.add(new DefaultMicroprofileRestClientExceptionMapper());
        }
        this.exceptionMappers.sort(Comparator.comparingInt(ResponseExceptionMapper::getPriority));
        this.clientBuilder.register((Object)new MicroProfileRestClientResponseFilter(this.exceptionMappers));
        this.clientBuilder.followRedirects(this.followRedirects);
        this.clientBuilder.multiQueryParamMode(this.toMultiQueryParamMode(this.queryParamStyle));
        Boolean trustAll = ConfigProvider.getConfig().getOptionalValue(TLS_TRUST_ALL, Boolean.class).orElse(false);
        this.clientBuilder.trustAll(trustAll.booleanValue());
        ClientImpl client = this.clientBuilder.build();
        WebTargetImpl target = (WebTargetImpl)client.target(this.uri);
        try {
            return (T)target.proxy(aClass);
        }
        catch (InvalidRestClientDefinitionException e) {
            throw new RestClientDefinitionException((Throwable)e);
        }
    }

    private MultiQueryParamMode toMultiQueryParamMode(QueryParamStyle queryParamStyle) {
        if (queryParamStyle == null) {
            return null;
        }
        switch (queryParamStyle) {
            case MULTI_PAIRS: {
                return MultiQueryParamMode.MULTI_PAIRS;
            }
            case COMMA_SEPARATED: {
                return MultiQueryParamMode.COMMA_SEPARATED;
            }
            case ARRAY_PAIRS: {
                return MultiQueryParamMode.ARRAY_PAIRS;
            }
        }
        return null;
    }
}

