/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.NoClassInterceptors;
import io.quarkus.rest.client.reactive.runtime.RestClientCDIDelegateBuilder;
import io.quarkus.runtime.MockedThroughWrapper;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.io.IOException;
import org.jboss.logging.Logger;

public abstract class RestClientReactiveCDIWrapperBase<T extends Closeable>
implements Closeable,
MockedThroughWrapper {
    private static final Logger log = Logger.getLogger(RestClientReactiveCDIWrapperBase.class);
    private final Class<T> jaxrsInterface;
    private final String baseUriFromAnnotation;
    private final String configKey;
    private T delegate;
    private Object mock;

    public RestClientReactiveCDIWrapperBase(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey, boolean requestScope) {
        this.jaxrsInterface = jaxrsInterface;
        this.baseUriFromAnnotation = baseUriFromAnnotation;
        this.configKey = configKey;
        if (!requestScope) {
            this.delegate();
        }
    }

    @Override
    @NoClassInterceptors
    public void close() throws IOException {
        if (this.mock == null && this.delegate != null) {
            this.delegate.close();
        }
    }

    @PreDestroy
    @NoClassInterceptors
    public void destroy() {
        try {
            if (this.mock == null) {
                this.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close cdi-created rest client instance", (Throwable)e);
        }
    }

    @NoClassInterceptors
    public Object getDelegate() {
        return this.mock == null ? this.delegate() : this.mock;
    }

    @NoClassInterceptors
    public void setMock(Object mock) {
        this.mock = mock;
    }

    @NoClassInterceptors
    public void clearMock() {
        this.mock = null;
    }

    @NoClassInterceptors
    private T delegate() {
        if (this.delegate == null) {
            this.delegate = (Closeable)RestClientCDIDelegateBuilder.createDelegate(this.jaxrsInterface, this.baseUriFromAnnotation, this.configKey);
        }
        return this.delegate;
    }
}

