/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive;

import io.quarkus.rest.client.reactive.runtime.RestClientRecorder;
import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import jakarta.enterprise.event.Observes;
import java.util.List;
import org.jboss.logging.Logger;

public class CertificateUpdateEventListener {
    private static final Logger LOG = Logger.getLogger(CertificateUpdateEventListener.class);

    public void onCertificateUpdate(@Observes CertificateUpdatedEvent event) {
        final String updatedTlsConfigurationName = event.name();
        TlsConfiguration updatedTlsConfiguration = event.tlsConfiguration();
        List<HttpClient> httpClients = RestClientRecorder.clientsUsingTlsConfig(updatedTlsConfigurationName);
        if (!httpClients.isEmpty()) {
            for (HttpClient httpClient : httpClients) {
                httpClient.updateSSLOptions(updatedTlsConfiguration.getSSLOptions(), (Handler)new Handler<AsyncResult<Boolean>>(){

                    public void handle(AsyncResult<Boolean> event) {
                        if (event.succeeded()) {
                            LOG.infof("Certificate reloaded for the REST client(s) using the TLS configuration (bucket) name '%s'", (Object)updatedTlsConfigurationName);
                        } else {
                            LOG.errorf(event.cause(), "Certificate reload failed  using the TLS configuration (bucket) name '%s'", (Object)event.cause(), (Object)updatedTlsConfigurationName);
                        }
                    }
                });
            }
        }
    }
}

