/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public abstract class JacksonCodeGenerator {
    protected final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    protected final IndexView jandexIndex;
    protected final Set<String> generatedClassNames = new HashSet<String>();
    protected final Deque<ClassInfo> toBeGenerated = new ArrayDeque<ClassInfo>();

    public JacksonCodeGenerator(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, IndexView jandexIndex) {
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.jandexIndex = jandexIndex;
    }

    protected abstract String getSuperClassName();

    protected String[] getInterfacesNames(ClassInfo classInfo) {
        return new String[0];
    }

    protected abstract String getClassSuffix();

    public Collection<String> create(Collection<ClassInfo> classInfos) {
        HashSet<String> createdClasses = new HashSet<String>();
        this.toBeGenerated.addAll(classInfos);
        while (!this.toBeGenerated.isEmpty()) {
            this.create(this.toBeGenerated.removeFirst()).ifPresent(createdClasses::add);
        }
        return createdClasses;
    }

    private Optional<String> create(ClassInfo classInfo) {
        String beanClassName = classInfo.name().toString();
        if (JacksonCodeGenerator.vetoedClass(classInfo, beanClassName) || !this.generatedClassNames.add(beanClassName)) {
            return Optional.empty();
        }
        String generatedClassName = beanClassName + this.getClassSuffix();
        try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, true), generatedClassName, null, this.getSuperClassName(), this.getInterfacesNames(classInfo));){
            this.createConstructor(classCreator, beanClassName);
            boolean valid = this.createSerializationMethod(classInfo, classCreator, beanClassName);
            Optional<String> optional = valid ? Optional.of(generatedClassName) : Optional.empty();
            return optional;
        }
    }

    private void createConstructor(ClassCreator classCreator, String beanClassName) {
        MethodCreator constructor = classCreator.getConstructorCreator(new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)this.getSuperClassName(), (String[])new String[]{"java.lang.Class"}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(beanClassName)});
        constructor.returnVoid();
    }

    protected abstract boolean createSerializationMethod(ClassInfo var1, ClassCreator var2, String var3);

    protected Collection<FieldInfo> classFields(ClassInfo classInfo) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        this.classFields(classInfo, fields);
        return fields;
    }

    protected void classFields(ClassInfo classInfo, Collection<FieldInfo> fields) {
        fields.addAll(classInfo.fields());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classFields((ClassInfo)superClassInfo, fields);
            return null;
        });
    }

    protected <T> T onSuperClass(ClassInfo classInfo, Function<ClassInfo, T> f) {
        ClassInfo superClassInfo;
        Type superType = classInfo.superClassType();
        if (superType != null && !JacksonCodeGenerator.vetoedClassName(superType.name().toString()) && (superClassInfo = this.jandexIndex.getClassByName(superType.name())) != null) {
            return f.apply(superClassInfo);
        }
        return null;
    }

    protected Collection<MethodInfo> classMethods(ClassInfo classInfo) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        this.classMethods(classInfo, methods);
        return methods;
    }

    private void classMethods(ClassInfo classInfo, Collection<MethodInfo> methods) {
        methods.addAll(classInfo.methods());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classMethods((ClassInfo)superClassInfo, methods);
            return null;
        });
    }

    protected MethodInfo findMethod(ClassInfo classInfo, String methodName, Type ... parameters) {
        MethodInfo method = classInfo.method(methodName, parameters);
        return method != null ? method : this.onSuperClass(classInfo, superClassInfo -> this.findMethod((ClassInfo)superClassInfo, methodName, parameters));
    }

    protected static String ucFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected static boolean vetoedClass(ClassInfo classInfo, String className) {
        return classInfo.isAbstract() || classInfo.isInterface() || JacksonCodeGenerator.vetoedClassName(className);
    }

    private static boolean vetoedClassName(String className) {
        return className.startsWith("java.") || className.startsWith("jakarta.") || className.startsWith("io.vertx.core.json.");
    }

    protected FieldKind registerTypeToBeGenerated(Type fieldType, String typeName) {
        if (fieldType instanceof TypeVariable) {
            return FieldKind.TYPE_VARIABLE;
        }
        if (fieldType instanceof ArrayType) {
            ArrayType aType = (ArrayType)fieldType;
            this.registerTypeToBeGenerated(aType.constituent());
            return FieldKind.ARRAY;
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fieldType;
            if (pType.arguments().size() == 1) {
                if (typeName.equals("java.util.List") || typeName.equals("java.util.Collection") || typeName.equals("java.lang.Iterable")) {
                    this.registerTypeToBeGenerated((Type)pType.arguments().get(0));
                    return FieldKind.LIST;
                }
                if (typeName.equals("java.util.Set")) {
                    this.registerTypeToBeGenerated((Type)pType.arguments().get(0));
                    return FieldKind.SET;
                }
            }
            if (pType.arguments().size() == 2 && typeName.equals("java.util.Map")) {
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                return FieldKind.MAP;
            }
        }
        this.registerTypeToBeGenerated(typeName);
        return FieldKind.OBJECT;
    }

    private void registerTypeToBeGenerated(Type type) {
        this.registerTypeToBeGenerated(type.name().toString());
    }

    private void registerTypeToBeGenerated(String typeName) {
        ClassInfo classInfo = this.jandexIndex.getClassByName(typeName);
        if (classInfo != null && !JacksonCodeGenerator.vetoedClass(classInfo, typeName) && this.shouldGenerateCodeFor(classInfo)) {
            this.toBeGenerated.add(classInfo);
        }
    }

    protected boolean shouldGenerateCodeFor(ClassInfo classInfo) {
        return !classInfo.isEnum();
    }

    private MethodInfo getterMethodInfo(ClassInfo classInfo, FieldInfo fieldInfo) {
        MethodInfo namedAccessor = this.findMethod(classInfo, fieldInfo.name(), new Type[0]);
        if (namedAccessor != null) {
            return namedAccessor;
        }
        String methodName = (fieldInfo.type().name().toString().equals("boolean") ? "is" : "get") + JacksonCodeGenerator.ucFirst(fieldInfo.name());
        return this.findMethod(classInfo, methodName, new Type[0]);
    }

    protected FieldSpecs fieldSpecsFromField(ClassInfo classInfo, FieldInfo fieldInfo) {
        if (Modifier.isStatic(fieldInfo.flags())) {
            return null;
        }
        MethodInfo getterMethodInfo = this.getterMethodInfo(classInfo, fieldInfo);
        if (getterMethodInfo != null) {
            return new FieldSpecs(fieldInfo, getterMethodInfo);
        }
        if (Modifier.isPublic(fieldInfo.flags())) {
            return new FieldSpecs(fieldInfo);
        }
        return null;
    }

    protected static enum FieldKind {
        OBJECT(false),
        ARRAY(false),
        LIST(true),
        SET(true),
        MAP(true),
        TYPE_VARIABLE(true);

        private boolean generic;

        private FieldKind(boolean generic) {
            this.generic = generic;
        }

        public boolean isGeneric() {
            return this.generic;
        }
    }

    protected static class FieldSpecs {
        final String fieldName;
        final String jsonName;
        final Type fieldType;
        private final Map<String, AnnotationInstance> annotations = new HashMap<String, AnnotationInstance>();
        MethodInfo methodInfo;
        FieldInfo fieldInfo;

        FieldSpecs(FieldInfo fieldInfo) {
            this(fieldInfo, null);
        }

        FieldSpecs(MethodInfo methodInfo) {
            this(null, methodInfo);
        }

        FieldSpecs(FieldInfo fieldInfo, MethodInfo methodInfo) {
            if (fieldInfo != null) {
                this.fieldInfo = fieldInfo;
                fieldInfo.annotations().forEach(a -> this.annotations.put(a.name().toString(), (AnnotationInstance)a));
            }
            if (methodInfo != null) {
                this.methodInfo = methodInfo;
                methodInfo.annotations().forEach(a -> this.annotations.put(a.name().toString(), (AnnotationInstance)a));
            }
            this.fieldType = this.fieldType();
            this.fieldName = this.fieldName();
            this.jsonName = this.jsonName();
        }

        public boolean isPublicField() {
            return this.fieldInfo != null && Modifier.isPublic(this.fieldInfo.flags());
        }

        private Type fieldType() {
            if (this.isPublicField()) {
                return this.fieldInfo.type();
            }
            if (this.methodInfo.name().startsWith("set")) {
                return this.methodInfo.parameterType(0);
            }
            return this.methodInfo.returnType();
        }

        private String jsonName() {
            AnnotationValue value;
            AnnotationInstance jsonProperty = this.annotations.get(JsonProperty.class.getName());
            if (jsonProperty != null && (value = jsonProperty.value()) != null && !value.asString().isEmpty()) {
                return value.asString();
            }
            return this.fieldName();
        }

        private String fieldName() {
            return this.fieldInfo != null ? this.fieldInfo.name() : this.fieldNameFromMethod(this.methodInfo);
        }

        private String fieldNameFromMethod(MethodInfo methodInfo) {
            String methodName = methodInfo.name();
            if (methodName.startsWith("is")) {
                return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            }
            if (methodName.startsWith("get") || methodName.startsWith("set")) {
                return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            }
            return methodName;
        }

        boolean hasUnknownAnnotation() {
            return this.annotations.keySet().stream().anyMatch(FieldSpecs::isUnknownAnnotation);
        }

        private static boolean isUnknownAnnotation(String ann) {
            if (ann.startsWith("com.fasterxml.jackson.")) {
                return !ann.equals(JsonProperty.class.getName());
            }
            return false;
        }

        ResultHandle toValueWriterHandle(BytecodeCreator bytecode, ResultHandle valueHandle) {
            return switch (this.fieldType.name().toString()) {
                case "char", "java.lang.Character" -> bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"charAt", Character.TYPE, (Class[])new Class[]{Integer.TYPE}), valueHandle, new ResultHandle[]{bytecode.load(0)});
                default -> valueHandle;
            };
        }

        ResultHandle toValueReaderHandle(BytecodeCreator bytecode, ResultHandle valueHandle) {
            ResultHandle handle = this.accessorHandle(bytecode, valueHandle);
            return switch (this.fieldType.name().toString()) {
                case "char", "java.lang.Character" -> bytecode.invokeStaticMethod(MethodDescriptor.ofMethod(Character.class, (String)"toString", String.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{handle});
                default -> handle;
            };
        }

        private ResultHandle accessorHandle(BytecodeCreator bytecode, ResultHandle valueHandle) {
            if (this.methodInfo != null) {
                if (this.methodInfo.declaringClass().isInterface()) {
                    return bytecode.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)this.methodInfo), valueHandle, new ResultHandle[0]);
                }
                return bytecode.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)this.methodInfo), valueHandle, new ResultHandle[0]);
            }
            return bytecode.readInstanceField(FieldDescriptor.of((FieldInfo)this.fieldInfo), valueHandle);
        }

        String writtenType() {
            return switch (this.fieldType.name().toString()) {
                case "char", "java.lang.Character" -> "java.lang.String";
                case "java.lang.Integer" -> "int";
                case "java.lang.Short" -> "short";
                case "java.lang.Long" -> "long";
                case "java.lang.Double" -> "double";
                case "java.lang.Float" -> "float";
                case "java.lang.Boolean" -> "boolean";
                default -> this.fieldType.name().toString();
            };
        }

        String[] rolesAllowed() {
            AnnotationInstance secureField = this.annotations.get(SecureField.class.getName());
            if (secureField != null) {
                AnnotationValue rolesAllowed = secureField.value("rolesAllowed");
                return rolesAllowed != null ? rolesAllowed.asStringArray() : null;
            }
            return null;
        }
    }
}

