/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;

@Singleton
public class EagerSecurityContext {
    static EagerSecurityContext instance = null;
    private final HttpSecurityPolicy.AuthorizationRequestContext authorizationRequestContext;
    final AbstractPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy;
    final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> eventHelper;
    final InjectableInstance<CurrentIdentityAssociation> identityAssociation;
    final EagerSecurityInterceptorStorage interceptorStorage;
    final AuthorizationController authorizationController;
    final SecurityCheckStorage securityCheckStorage;
    final boolean doNotRunPermissionSecurityCheck;
    final boolean isProactiveAuthDisabled;

    EagerSecurityContext(Event<AuthorizationFailureEvent> authorizationFailureEvent, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, Event<AuthorizationSuccessEvent> authorizationSuccessEvent, BeanManager beanManager, InjectableInstance<CurrentIdentityAssociation> identityAssociation, AuthorizationController authorizationController, SecurityCheckStorage securityCheckStorage, HttpConfiguration httpConfig, BlockingSecurityExecutor blockingExecutor, HttpBuildTimeConfig buildTimeConfig, Instance<HttpSecurityPolicy> installedPolicies) {
        InstanceHandle interceptorStorageHandle = Arc.container().instance(EagerSecurityInterceptorStorage.class, new Annotation[0]);
        this.interceptorStorage = interceptorStorageHandle.isAvailable() ? (EagerSecurityInterceptorStorage)interceptorStorageHandle.get() : null;
        this.isProactiveAuthDisabled = !buildTimeConfig.auth.proactive;
        this.identityAssociation = identityAssociation;
        this.authorizationController = authorizationController;
        this.securityCheckStorage = securityCheckStorage;
        this.eventHelper = new SecurityEventHelper(authorizationSuccessEvent, authorizationFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
        AbstractPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy = new AbstractPathMatchingHttpSecurityPolicy(httpConfig.auth.permissions, httpConfig.auth.rolePolicy, buildTimeConfig.rootPath, installedPolicies, PolicyMappingConfig.AppliesTo.JAXRS);
        if (jaxRsPathMatchingPolicy.hasNoPermissions()) {
            this.jaxRsPathMatchingPolicy = null;
            this.authorizationRequestContext = null;
            this.doNotRunPermissionSecurityCheck = true;
        } else {
            this.jaxRsPathMatchingPolicy = jaxRsPathMatchingPolicy;
            this.authorizationRequestContext = new HttpSecurityPolicy.DefaultAuthorizationRequestContext(blockingExecutor);
            this.doNotRunPermissionSecurityCheck = false;
        }
    }

    void initSingleton(@Observes StartupEvent event) {
        instance = this;
    }

    void destroySingleton(@Observes ShutdownEvent event) {
        instance = null;
    }

    Uni<SecurityIdentity> getDeferredIdentity() {
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> get() {
                return ((CurrentIdentityAssociation)EagerSecurityContext.instance.identityAssociation.get()).getDeferredIdentity();
            }
        });
    }

    Uni<SecurityIdentity> getPermissionCheck(ResteasyReactiveRequestContext requestContext, final SecurityIdentity identity) {
        final RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (routingContext == null) {
            throw new IllegalStateException("HTTP Security policy applied only on Quarkus REST cannot be run as 'RoutingContext' is null");
        }
        return this.jaxRsPathMatchingPolicy.checkPermission(routingContext, identity == null ? this.getDeferredIdentity() : Uni.createFrom().item((Object)identity), this.authorizationRequestContext).flatMap((Function)new Function<HttpSecurityPolicy.CheckResult, Uni<? extends 1SecurityCheckWithIdentity>>(){

            @Override
            public Uni<1SecurityCheckWithIdentity> apply(final HttpSecurityPolicy.CheckResult checkResult) {
                record SecurityCheckWithIdentity(SecurityIdentity identity, HttpSecurityPolicy.CheckResult checkResult) {
                }
                if (identity != null) {
                    return Uni.createFrom().item((Object)new SecurityCheckWithIdentity(identity, checkResult));
                }
                if (checkResult.isPermitted() && checkResult.getAugmentedIdentity() == null) {
                    return Uni.createFrom().item((Object)new SecurityCheckWithIdentity(null, checkResult));
                }
                return EagerSecurityContext.this.getDeferredIdentity().map((Function)new Function<SecurityIdentity, SecurityCheckWithIdentity>(){

                    @Override
                    public SecurityCheckWithIdentity apply(SecurityIdentity identity1) {
                        return new SecurityCheckWithIdentity(identity1, checkResult);
                    }
                });
            }
        }).map((Function)new Function<1SecurityCheckWithIdentity, SecurityIdentity>(){

            @Override
            public SecurityIdentity apply(1SecurityCheckWithIdentity checkWithIdentity) {
                SecurityIdentity newIdentity;
                HttpSecurityPolicy.CheckResult checkResult = checkWithIdentity.checkResult();
                if (checkResult.getAugmentedIdentity() == null) {
                    newIdentity = checkWithIdentity.identity();
                } else if (checkResult.getAugmentedIdentity() != checkWithIdentity.identity()) {
                    newIdentity = checkResult.getAugmentedIdentity();
                    routingContext.setUser((User)new QuarkusHttpUser(newIdentity));
                    ((CurrentIdentityAssociation)EagerSecurityContext.this.identityAssociation.get()).setIdentity(newIdentity);
                } else {
                    newIdentity = checkResult.getAugmentedIdentity();
                }
                if (checkResult.isPermitted()) {
                    if (EagerSecurityContext.this.eventHelper.fireEventOnSuccess()) {
                        EagerSecurityContext.this.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(newIdentity, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), routingContext)));
                    }
                    return newIdentity;
                }
                Object exception = newIdentity.isAnonymous() ? new UnauthorizedException() : new ForbiddenException();
                if (EagerSecurityContext.this.eventHelper.fireEventOnFailure()) {
                    EagerSecurityContext.this.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(newIdentity, (Throwable)exception, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), routingContext)));
                }
                throw exception;
            }
        });
    }

    static MethodDescription lazyMethodToMethodDescription(ResteasyReactiveResourceInfo lazyMethod) {
        return new MethodDescription(lazyMethod.getActualDeclaringClassName(), lazyMethod.getName(), MethodDescription.typesAsStrings((Class[])lazyMethod.getParameterTypes()));
    }
}

