/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.server.deployment.FormDataOutputMapperGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartMessageBodyWriter;

public class QuarkusMultipartReturnTypeHandler
implements EndpointIndexer.MultipartReturnTypeIndexerExtension {
    private final Map<String, Boolean> multipartOutputGeneratedPopulators = new HashMap<String, Boolean>();
    final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    final Predicate<String> applicationClassPredicate;
    final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;

    public QuarkusMultipartReturnTypeHandler(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, Predicate<String> applicationClassPredicate, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.applicationClassPredicate = applicationClassPredicate;
        this.reflectiveClassProducer = reflectiveClassProducer;
    }

    public boolean handleMultipartForReturnType(AdditionalWriters additionalWriters, ClassInfo multipartClassInfo, IndexView index) {
        String className = multipartClassInfo.name().toString();
        Boolean canHandle = this.multipartOutputGeneratedPopulators.get(className);
        if (canHandle != null) {
            return canHandle;
        }
        canHandle = false;
        if (FormDataOutputMapperGenerator.isReturnTypeCompatible(multipartClassInfo, index)) {
            additionalWriters.add(MultipartMessageBodyWriter.class.getName(), "multipart/form-data", className);
            String mapperClassName = FormDataOutputMapperGenerator.generate(multipartClassInfo, (ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, this.applicationClassPredicate.test(className)), index);
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{MultipartMessageBodyWriter.class.getName()}));
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{className}));
            this.reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{mapperClassName}));
            canHandle = true;
        }
        this.multipartOutputGeneratedPopulators.put(className, canHandle);
        return canHandle;
    }
}

