/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.standalone.QuarkusResteasySecurityContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;

@PreMatching
@Priority(value=5001)
@Provider
public class SecurityContextFilter
implements ContainerRequestFilter {
    @Inject
    SecurityIdentity old;
    @Inject
    CurrentIdentityAssociation currentIdentityAssociation;
    @Inject
    RoutingContext routingContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        final SecurityContext modified = requestContext.getSecurityContext();
        if (modified instanceof ServletSecurityContext || modified instanceof QuarkusResteasySecurityContext) {
            return;
        }
        final Set oldCredentials = this.old.getCredentials();
        final Map oldAttributes = this.old.getAttributes();
        SecurityIdentity newIdentity = new SecurityIdentity(){

            public Principal getPrincipal() {
                return modified.getUserPrincipal();
            }

            public boolean isAnonymous() {
                return modified.getUserPrincipal() == null;
            }

            public Set<String> getRoles() {
                throw new UnsupportedOperationException("retrieving all roles not supported when JAX-RS security context has been replaced");
            }

            public boolean hasRole(String role) {
                return modified.isUserInRole(role);
            }

            public <T extends Credential> T getCredential(Class<T> credentialType) {
                for (Credential cred : this.getCredentials()) {
                    if (!credentialType.isAssignableFrom(cred.getClass())) continue;
                    return (T)cred;
                }
                return null;
            }

            public Set<Credential> getCredentials() {
                return oldCredentials;
            }

            public <T> T getAttribute(String name) {
                return (T)oldAttributes.get(name);
            }

            public Map<String, Object> getAttributes() {
                return oldAttributes;
            }

            public Uni<Boolean> checkPermission(Permission permission) {
                return Uni.createFrom().nullItem();
            }
        };
        this.routingContext.setUser((User)new QuarkusHttpUser(newIdentity));
        this.currentIdentityAssociation.setIdentity(newIdentity);
    }
}

