/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.common.runtime.DelegateInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import jakarta.enterprise.event.Event;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

public final class SkipPredicateInvoker
extends DelegateInvoker {
    private static final Logger LOG = Logger.getLogger(SkipPredicateInvoker.class);
    private final Scheduled.SkipPredicate predicate;
    private final Event<SkippedExecution> event;

    public SkipPredicateInvoker(ScheduledInvoker delegate, Scheduled.SkipPredicate predicate, Event<SkippedExecution> event) {
        super(delegate);
        this.predicate = predicate;
        this.event = event;
    }

    @Override
    public CompletionStage<Void> invoke(ScheduledExecution execution) throws Exception {
        if (this.predicate.test(execution)) {
            LOG.debugf("Skipped scheduled invoker execution: %s", (Object)this.delegate.getClass().getName());
            SkippedExecution payload = new SkippedExecution(execution, this.predicate.getClass().getName());
            try {
                this.event.fire((Object)payload);
                this.event.fireAsync((Object)payload);
            }
            catch (Exception e) {
                LOG.errorf("Error while firing SkippedExecution event", (Object)e);
            }
            return CompletableFuture.completedStage(null);
        }
        return this.invokeDelegate(execution);
    }
}

