/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Objects;
import java.util.Set;

public final class DiscoveredImplementationsBuildItem
extends SimpleBuildItem {
    private final String autoImplementation;
    private final Set<String> implementations;
    private final boolean useCompositeScheduler;

    DiscoveredImplementationsBuildItem(String autoImplementation, Set<String> implementations, boolean useCompositeScheduler) {
        this.autoImplementation = Objects.requireNonNull(autoImplementation);
        this.implementations = Objects.requireNonNull(implementations);
        this.useCompositeScheduler = useCompositeScheduler;
    }

    public String getAutoImplementation() {
        return this.autoImplementation;
    }

    public Set<String> getImplementations() {
        return this.implementations;
    }

    public boolean isCompositeSchedulerUsed() {
        return this.useCompositeScheduler && this.implementations.size() > 1;
    }

    public boolean isAutoImplementation(String implementation) {
        return this.autoImplementation.equals(implementation);
    }
}

