/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.smallrye.mutiny.Uni;
import java.security.Principal;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@RequestScoped
public class SecurityIdentityAssociation
implements CurrentIdentityAssociation {
    private volatile SecurityIdentity identity;
    private volatile Uni<SecurityIdentity> deferredIdentity;
    @Inject
    IdentityProviderManager identityProviderManager;

    @Produces
    @RequestScoped
    Principal principal() {
        return new Principal(){

            @Override
            public String getName() {
                return SecurityIdentityAssociation.this.getIdentity().getPrincipal().getName();
            }
        };
    }

    public void setIdentity(@Observes SecurityIdentity identity) {
        this.identity = identity;
        this.deferredIdentity = null;
    }

    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.identity = null;
        this.deferredIdentity = identity;
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        return this.deferredIdentity;
    }

    public SecurityIdentity getIdentity() {
        if (this.identity == null) {
            if (this.deferredIdentity != null) {
                this.identity = (SecurityIdentity)this.deferredIdentity.await().indefinitely();
            }
            if (this.identity == null) {
                this.identity = (SecurityIdentity)this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).await().indefinitely();
            }
        }
        return this.identity;
    }
}

