/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@RequestScoped
public class SecurityIdentityProxy
implements SecurityIdentity {
    @Inject
    CurrentIdentityAssociation association;

    public Principal getPrincipal() {
        return this.association.getIdentity().getPrincipal();
    }

    public boolean isAnonymous() {
        return this.association.getIdentity().isAnonymous();
    }

    public Set<String> getRoles() {
        return this.association.getIdentity().getRoles();
    }

    public boolean hasRole(String role) {
        return this.association.getIdentity().hasRole(role);
    }

    public <T extends Credential> T getCredential(Class<T> credentialType) {
        return (T)this.association.getIdentity().getCredential(credentialType);
    }

    public Set<Credential> getCredentials() {
        return this.association.getIdentity().getCredentials();
    }

    public <T> T getAttribute(String name) {
        return (T)this.association.getIdentity().getAttribute(name);
    }

    public Map<String, Object> getAttributes() {
        return this.association.getIdentity().getAttributes();
    }

    public Set<Permission> getPermissions() {
        return this.association.getIdentity().getPermissions();
    }

    public Uni<Boolean> checkPermission(final Permission permission) {
        return this.association.getDeferredIdentity().flatMap((Function)new Function<SecurityIdentity, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(SecurityIdentity identity) {
                return identity.checkPermission(permission);
            }
        });
    }

    public boolean checkPermissionBlocking(Permission permission) {
        return this.association.getIdentity().checkPermissionBlocking(permission);
    }
}

