/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class HealthOpenAPIFilter
implements OASFilter {
    private static final List<String> MICROPROFILE_HEALTH_TAG = Collections.singletonList("MicroProfile Health");
    private static final String HEALTH_RESPONSE_SCHEMA_NAME = "HealthResponse";
    private static final String HEALTH_CHECK_SCHEMA_NAME = "HealthCheck";
    private static final Schema healthResponseSchemaDefinition = new SchemaImpl("HealthResponse").type(Schema.SchemaType.OBJECT).properties(Map.ofEntries(Map.entry("status", new SchemaImpl().type(Schema.SchemaType.STRING).enumeration(List.of("UP", "DOWN"))), Map.entry("checks", new SchemaImpl().type(Schema.SchemaType.ARRAY).items((Schema)new SchemaImpl().ref("#/components/schemas/HealthCheck")))));
    private static final Schema healthCheckSchemaDefinition = new SchemaImpl("HealthCheck").type(Schema.SchemaType.OBJECT).properties(Map.ofEntries(Map.entry("name", new SchemaImpl().type(Schema.SchemaType.STRING)), Map.entry("status", new SchemaImpl().type(Schema.SchemaType.STRING).enumeration(List.of("UP", "DOWN"))), Map.entry("data", new SchemaImpl().type(Schema.SchemaType.OBJECT).nullable(Boolean.TRUE))));
    private final String rootPath;
    private final String livenessPath;
    private final String readinessPath;
    private final String startupPath;

    public HealthOpenAPIFilter(String rootPath, String livenessPath, String readinessPath, String startupPath) {
        this.rootPath = rootPath;
        this.livenessPath = livenessPath;
        this.readinessPath = readinessPath;
        this.startupPath = startupPath;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents((Components)new ComponentsImpl());
        }
        openAPI.getComponents().addSchema(HEALTH_RESPONSE_SCHEMA_NAME, healthResponseSchemaDefinition);
        openAPI.getComponents().addSchema(HEALTH_CHECK_SCHEMA_NAME, healthCheckSchemaDefinition);
        if (openAPI.getPaths() == null) {
            openAPI.setPaths((Paths)new PathsImpl());
        }
        Paths paths = openAPI.getPaths();
        paths.addPathItem(this.rootPath, this.createHealthEndpoint("MicroProfile Health Endpoint", "MicroProfile Health provides a way for your application to distribute information about its healthiness state to state whether or not it is able to function properly", "Check the health of the application", "microprofile_health_root", "An aggregated view of the Liveness, Readiness and Startup of this application"));
        paths.addPathItem(this.livenessPath, this.createHealthEndpoint("MicroProfile Health - Liveness Endpoint", "Liveness checks are utilized to tell whether the application should be restarted", "Check the liveness of the application", "microprofile_health_liveness", "The Liveness check of this application"));
        paths.addPathItem(this.readinessPath, this.createHealthEndpoint("MicroProfile Health - Readiness Endpoint", "Readiness checks are used to tell whether the application is able to process requests", "Check the readiness of the application", "microprofile_health_readiness", "The Readiness check of this application"));
        paths.addPathItem(this.startupPath, this.createHealthEndpoint("MicroProfile Health - Startup Endpoint", "Startup checks are an used to tell when the application has started", "Check the startup of the application", "microprofile_health_startup", "The Startup check of this application"));
    }

    private PathItem createHealthEndpoint(String endpointDescription, String endpointSummary, String operationDescription, String operationId, String operationSummary) {
        Content content = new ContentImpl().addMediaType("application/json", new MediaTypeImpl().schema((Schema)new SchemaImpl().ref("#/components/schemas/HealthResponse")));
        APIResponses responses = new APIResponsesImpl().addAPIResponse("200", new APIResponseImpl().description("OK").content(content)).addAPIResponse("503", new APIResponseImpl().description("Service Unavailable").content(content)).addAPIResponse("500", new APIResponseImpl().description("Internal Server Error").content(content));
        Operation getOperation = new OperationImpl().operationId(operationId).description(operationDescription).tags(MICROPROFILE_HEALTH_TAG).summary(operationSummary).responses(responses);
        return new PathItemImpl().description(endpointDescription).summary(endpointSummary).GET(getOperation);
    }
}

