/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.smallrye.jwt.runtime.auth.SmallRyeJwtConfig;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.security.Principal;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MpJwtValidator
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger log = Logger.getLogger(MpJwtValidator.class);
    final JWTParser parser;
    final boolean blockingAuthentication;

    public MpJwtValidator() {
        this.parser = null;
        this.blockingAuthentication = false;
    }

    @Inject
    public MpJwtValidator(JWTParser parser, SmallRyeJwtConfig config) {
        this.parser = parser;
        this.blockingAuthentication = config == null ? false : config.blockingAuthentication;
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        if (!this.blockingAuthentication) {
            return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

                @Override
                public void accept(UniEmitter<? super SecurityIdentity> uniEmitter) {
                    try {
                        uniEmitter.complete((Object)MpJwtValidator.this.createSecurityIdentity(request));
                    }
                    catch (AuthenticationFailedException e) {
                        uniEmitter.fail((Throwable)e);
                    }
                }
            });
        }
        return context.runBlocking(() -> this.createSecurityIdentity(request));
    }

    private SecurityIdentity createSecurityIdentity(TokenAuthenticationRequest request) {
        try {
            JsonWebToken jwtPrincipal = this.parser.parse(request.getToken().getToken());
            return QuarkusSecurityIdentity.builder().setPrincipal((Principal)jwtPrincipal).addCredential((Credential)request.getToken()).addRoles(jwtPrincipal.getGroups()).addAttribute("quarkus.user", (Object)jwtPrincipal).build();
        }
        catch (ParseException e) {
            log.debug((Object)"Authentication failed", (Throwable)e);
            throw new AuthenticationFailedException((Throwable)e);
        }
    }
}

