/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.restclient.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyDotNames;
import io.quarkus.smallrye.restclient.runtime.RestClientBase;
import io.quarkus.smallrye.restclient.runtime.SmallRyeRestClientRecorder;
import io.smallrye.restclient.DefaultResponseExceptionMapper;
import io.smallrye.restclient.RestClientProxy;
import io.smallrye.restclient.header.IncomingHeadersProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ResteasyClientProxy;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.spi.ResteasyConfiguration;

class SmallRyeRestClientProcessor {
    private static final Logger log = Logger.getLogger(SmallRyeRestClientProcessor.class);
    private static final DotName REST_CLIENT = DotName.createSimple((String)RestClient.class.getName());
    private static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)RegisterRestClient.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName REGISTER_PROVIDER = DotName.createSimple((String)RegisterProvider.class.getName());
    private static final DotName REGISTER_PROVIDERS = DotName.createSimple((String)RegisterProviders.class.getName());
    private static final String PROVIDERS_SERVICE_FILE = "META-INF/services/" + Providers.class.getName();

    SmallRyeRestClientProcessor() {
    }

    @BuildStep
    void setupProviders(BuildProducer<SubstrateResourceBuildItem> resources, BuildProducer<SubstrateProxyDefinitionBuildItem> proxyDefinition) {
        proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{"javax.ws.rs.ext.Providers"}));
        resources.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{PROVIDERS_SERVICE_FILE}));
    }

    @BuildStep
    SubstrateProxyDefinitionBuildItem addProxy() {
        return new SubstrateProxyDefinitionBuildItem(new String[]{ResteasyConfiguration.class.getName()});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setup(BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, SmallRyeRestClientRecorder smallRyeRestClientRecorder) {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-rest-client"));
        smallRyeRestClientRecorder.setRestClientBuilderResolver();
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RestClient.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{LogFactoryImpl.class.getName(), Jdk14Logger.class.getName(), DefaultResponseExceptionMapper.class.getName(), ResteasyProviderFactoryImpl.class.getName(), ProxyBuilderImpl.class.getName(), ClientRequestFilter[].class.getName(), ClientResponseFilter[].class.getName(), ReaderInterceptor[].class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{ResteasyClientBuilder.class.getName()}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void processInterfaces(CombinedIndexBuildItem combinedIndexBuildItem, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<SubstrateProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<BeanRegistrarBuildItem> beanRegistrars, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<ServiceProviderBuildItem> serviceProvider, SmallRyeRestClientRecorder smallRyeRestClientRecorder) {
        final HashMap<DotName, ClassInfo> interfaces = new HashMap<DotName, ClassInfo>();
        HashSet<Type> returnTypes = new HashSet<Type>();
        IndexView index = combinedIndexBuildItem.getIndex();
        for (AnnotationInstance annotationInstance : index.getAnnotations(PATH)) {
            ClassInfo theInfo;
            AnnotationTarget target = annotationInstance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                theInfo = target.asClass();
            } else {
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                theInfo = target.asMethod().declaringClass();
            }
            if (!this.isRestClientInterface(index, theInfo)) continue;
            interfaces.put(theInfo.name(), theInfo);
            for (MethodInfo method : theInfo.methods()) {
                Type type = method.returnType();
                if (type.name().toString().contains("java.lang") || returnTypes.contains(type)) continue;
                returnTypes.add(type);
            }
        }
        if (interfaces.isEmpty()) {
            return;
        }
        for (Map.Entry entry : interfaces.entrySet()) {
            String iName = ((DotName)entry.getKey()).toString();
            proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{iName, ResteasyClientProxy.class.getName()}));
            proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{iName, RestClientProxy.class.getName()}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{iName}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{DefaultClientHeadersFactoryImpl.class.getName()}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(IncomingHeadersProvider.class.getName(), new String[]{io.quarkus.smallrye.restclient.runtime.IncomingHeadersProvider.class.getName()}));
        for (Type type : returnTypes) {
            if (!SmallRyeRestClientProcessor.isReflectionDeclarationRequiredFor(type)) continue;
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(type));
        }
        beanRegistrars.produce((BuildItem)new BeanRegistrarBuildItem(new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext registrationContext) {
                Config config = ConfigProvider.getConfig();
                for (Map.Entry entry : interfaces.entrySet()) {
                    DotName restClientName = (DotName)entry.getKey();
                    BeanConfigurator configurator = registrationContext.configure(restClientName);
                    configurator.addType(restClientName);
                    configurator.addQualifier(REST_CLIENT);
                    ScopeInfo scope = SmallRyeRestClientProcessor.this.computeDefaultScope(config, entry);
                    configurator.scope(scope);
                    configurator.creator(m -> {
                        ResultHandle interfaceHandle = m.loadClass(restClientName.toString());
                        ResultHandle baseUriHandle = m.load(SmallRyeRestClientProcessor.this.getBaseUri((ClassInfo)entry.getValue()));
                        ResultHandle baseHandle = m.newInstance(MethodDescriptor.ofConstructor(RestClientBase.class, (Class[])new Class[]{Class.class, String.class}), new ResultHandle[]{interfaceHandle, baseUriHandle});
                        ResultHandle ret = m.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"create", Object.class, (Class[])new Class[0]), baseHandle, new ResultHandle[0]);
                        m.returnValue(ret);
                    });
                    configurator.done();
                }
            }
        }));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("smallrye-rest-client"));
        smallRyeRestClientRecorder.setSslEnabled(sslNativeConfig.isEnabled());
    }

    private ScopeInfo computeDefaultScope(Config config, Map.Entry<DotName, ClassInfo> entry) {
        DotName restClientName = entry.getKey();
        ScopeInfo scopeInfo = BuiltinScope.DEPENDENT.getInfo();
        String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
        Optional scopeConfig = config.getOptionalValue(String.format("%s/mp-rest/scope", restClientName.toString()), String.class);
        if (scopeConfig.isPresent()) {
            DotName scope = DotName.createSimple((String)((String)scopeConfig.get()));
            BuiltinScope builtinScope = BuiltinScope.from((DotName)scope);
            if (builtinScope != null) {
                scopeInfo = builtinScope.getInfo();
            } else {
                log.warn((Object)String.format("Unsupported default scope %s provided for rest client %s. Defaulting to @Dependent.", scope, restClientName));
            }
        } else {
            Set annotations = entry.getValue().annotations().keySet();
            for (DotName annotationName : annotations) {
                BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
                if (builtinScope == null) continue;
                scopeInfo = builtinScope.getInfo();
                break;
            }
        }
        return scopeInfo;
    }

    private String getBaseUri(ClassInfo classInfo) {
        AnnotationInstance instance = classInfo.classAnnotation(REGISTER_REST_CLIENT);
        if (instance == null) {
            return "";
        }
        AnnotationValue value = instance.value("baseUri");
        if (value == null) {
            return "";
        }
        return value.asString();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, SmallRyeRestClientRecorder smallRyeRestClientRecorder) {
        smallRyeRestClientRecorder.initializeResteasyProviderFactory(jaxrsProvidersToRegisterBuildItem.useBuiltIn(), jaxrsProvidersToRegisterBuildItem.getProviders(), jaxrsProvidersToRegisterBuildItem.getContributedProviders());
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{providerToRegister}));
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        for (AnnotationInstance annotationInstance : allInstances) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{annotationInstance.value().asClass().toString()}));
        }
    }

    private boolean isRestClientInterface(IndexView index, ClassInfo classInfo) {
        return Modifier.isInterface(classInfo.flags()) && index.getAllKnownImplementors(classInfo.name()).isEmpty();
    }

    private static boolean isReflectionDeclarationRequiredFor(Type type) {
        DotName className = SmallRyeRestClientProcessor.getClassName(type);
        return className != null && !ResteasyDotNames.TYPES_IGNORED_FOR_REFLECTION.contains(className);
    }

    private static DotName getClassName(Type type) {
        switch (type.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                return type.name();
            }
            case ARRAY: {
                return SmallRyeRestClientProcessor.getClassName(type.asArrayType().component());
            }
        }
        return null;
    }
}

