/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork.deployment;

import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.EmptyBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.stork.SmallRyeStorkRecorder;
import io.quarkus.stork.StorkConfigProvider;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.smallrye.stork.spi.LoadBalancerProvider;
import io.smallrye.stork.spi.ServiceDiscoveryProvider;
import io.smallrye.stork.spi.ServiceRegistrarProvider;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import io.smallrye.stork.spi.internal.ServiceRegistrarLoader;
import java.util.Arrays;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class SmallRyeStorkProcessor {
    private static final String KUBERNETES_SERVICE_DISCOVERY_PROVIDER = "io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider";
    private static final Logger LOGGER = Logger.getLogger((String)SmallRyeStorkProcessor.class.getName());

    @BuildStep
    void registerServiceProviders(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)new ServiceProviderBuildItem(ConfigProvider.class.getName(), new String[]{StorkConfigProvider.class.getName()}));
        for (Class providerClass : Arrays.asList(LoadBalancerLoader.class, ServiceDiscoveryLoader.class, ServiceRegistrarLoader.class)) {
            services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)providerClass.getName()));
        }
    }

    @BuildStep
    UnremovableBeanBuildItem unremoveableBeans() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple(ServiceDiscoveryProvider.class), DotName.createSimple(ServiceDiscoveryLoader.class), DotName.createSimple(LoadBalancerProvider.class), DotName.createSimple(LoadBalancerLoader.class), DotName.createSimple(ServiceRegistrarProvider.class), DotName.createSimple(ServiceRegistrarLoader.class)});
    }

    @BuildStep
    @Produce(value=AlwaysBuildItem.class)
    void checkThatTheKubernetesExtensionIsUsedWhenKubernetesServiceDiscoveryInOnTheClasspath(Capabilities capabilities) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)KUBERNETES_SERVICE_DISCOVERY_PROVIDER) && !capabilities.isPresent("io.quarkus.kubernetes.client")) {
            LOGGER.warn((Object)"The application is using the Stork Kubernetes Service Discovery provider but does not depend on the `quarkus-kubernetes-client` extension. It is highly recommended to use the `io.quarkus:quarkus-kubernetes-client` extension with the Kubernetes service discovery. \nTo add this extension:\n - with the quarkus CLI, run: `quarkus ext add io.quarkus:quarkus-kubernetes-client`\n - with Apache Maven, run: `./mvnw quarkus:add-extension -Dextensions=\"io.quarkus:quarkus-kubernetes-client\"`\n - or just add the `io.quarkus:quarkus-kubernetes-client` dependency to the project");
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume.List(value={@Consume(value=AlwaysBuildItem.class), @Consume(value=RuntimeConfigSetupCompleteBuildItem.class), @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)})
    void initializeStork(SmallRyeStorkRecorder storkRecorder, ShutdownContextBuildItem shutdown, VertxBuildItem vertx) {
        storkRecorder.initialize((ShutdownContext)shutdown, vertx.getVertx());
    }

    private static final class AlwaysBuildItem
    extends EmptyBuildItem {
        private AlwaysBuildItem() {
        }
    }
}

