/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.stork.QuarkusStorkInfrastructure;
import io.quarkus.stork.QuarkusStorkObservableInfrastructure;
import io.quarkus.stork.StorkConfigProvider;
import io.quarkus.stork.StorkConfigUtil;
import io.quarkus.stork.StorkConfiguration;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.observability.ObservationCollector;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.List;

@Recorder
public class SmallRyeStorkRecorder {
    private final RuntimeValue<StorkConfiguration> runtimeConfig;

    public SmallRyeStorkRecorder(RuntimeValue<StorkConfiguration> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void initialize(ShutdownContext shutdown, RuntimeValue<Vertx> vertx) {
        List<ServiceConfig> serviceConfigs = StorkConfigUtil.toStorkServiceConfig((StorkConfiguration)this.runtimeConfig.getValue());
        StorkConfigProvider.init(serviceConfigs);
        Instance instance = CDI.current().select(ObservationCollector.class, new Annotation[0]);
        if (instance.isResolvable()) {
            Stork.initialize((StorkInfrastructure)new QuarkusStorkObservableInfrastructure((Vertx)vertx.getValue(), (ObservationCollector)instance.get()));
        } else {
            QuarkusStorkInfrastructure infrastructure = new QuarkusStorkInfrastructure((Vertx)vertx.getValue());
            Stork.initialize((StorkInfrastructure)infrastructure);
        }
        shutdown.addLastShutdownTask(new Runnable(){

            @Override
            public void run() {
                Stork.shutdown();
            }
        });
    }
}

