/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class TestHTTPConfigSourceProvider
implements ConfigSourceProvider {
    static final String TEST_URL_VALUE = "http://${quarkus.http.host:localhost}:${quarkus.http.test-port:8081}${quarkus.servlet.context-path:}";
    static final String TEST_URL_KEY = "test.url";
    static final String TEST_URL_SSL_VALUE = "https://${quarkus.http.host:localhost}:${quarkus.http.test-ssl-port:8444}${quarkus.servlet.context-path:}";
    static final String TEST_URL_SSL_KEY = "test.url.ssl";
    static final Map<String, String> entries;

    private static String sanitizeURL(String url) {
        return url.replace("0.0.0.0", "localhost");
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return Collections.singletonList(new TestURLConfigSource());
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TEST_URL_KEY, TestHTTPConfigSourceProvider.sanitizeURL(TEST_URL_VALUE));
        map.put(TEST_URL_SSL_KEY, TestHTTPConfigSourceProvider.sanitizeURL(TEST_URL_SSL_VALUE));
        map.put("%dev.test.url", TestHTTPConfigSourceProvider.sanitizeURL("http://${quarkus.http.host:localhost}:${quarkus.http.test-port:8080}${quarkus.servlet.context-path:}"));
        entries = Collections.unmodifiableMap(map);
    }

    static class TestURLConfigSource
    implements ConfigSource,
    Serializable {
        private static final long serialVersionUID = 4841094273900625000L;

        TestURLConfigSource() {
        }

        public Map<String, String> getProperties() {
            return entries;
        }

        public String getValue(String propertyName) {
            return entries.get(propertyName);
        }

        public String getName() {
            return "test URL provider";
        }

        public int getOrdinal() {
            return -2147482648;
        }
    }
}

