/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;

public class TestInstantiator {
    private static final Logger log = Logger.getLogger(TestInstantiator.class);

    public static Object instantiateTest(Class<?> testClass, ClassLoader classLoader) {
        try {
            Class<?> actualTestClass = Class.forName(testClass.getName(), true, Thread.currentThread().getContextClassLoader());
            Class<?> cdi = Thread.currentThread().getContextClassLoader().loadClass("jakarta.enterprise.inject.spi.CDI");
            Object instance = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Method selectMethod = cdi.getMethod("select", Class.class, Annotation[].class);
            Object cdiInstance = selectMethod.invoke(instance, actualTestClass, new Annotation[0]);
            return selectMethod.getReturnType().getMethod("get", new Class[0]).invoke(cdiInstance, new Object[0]);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to initialize test as a CDI bean, falling back to direct initialization", (Throwable)e);
            try {
                Constructor<?> ctor = testClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

