/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.logging.LogRuntimeConfig;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultJarLauncher;
import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.ProcessReader;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DefaultNativeImageLauncher
implements NativeImageLauncher {
    private static final Logger log = Logger.getLogger(DefaultNativeImageLauncher.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private Map<String, String> env;
    private String nativeImagePath;
    private String configuredOutputDirectory;
    private Class<?> testClass;
    private Process quarkusProcess;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private Path logFile;

    @Override
    public void init(NativeImageLauncher.NativeImageInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.nativeImagePath = initContext.nativeImagePath();
        this.configuredOutputDirectory = initContext.getConfiguredOutputDirectory();
        this.argLine = initContext.argLine();
        this.env = initContext.env();
        this.testClass = initContext.testClass();
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        try {
            this.start(args, false);
            ProcessReader error = new ProcessReader(this.quarkusProcess.getErrorStream());
            ProcessReader stdout = new ProcessReader(this.quarkusProcess.getInputStream());
            Thread t1 = new Thread((Runnable)error, "Error stream reader");
            t1.start();
            Thread t2 = new Thread((Runnable)stdout, "Stdout stream reader");
            t2.start();
            t1.join();
            t2.join();
            byte[] s = stdout.get();
            byte[] e = error.get();
            return new ArtifactLauncher.LaunchResult(this.quarkusProcess.waitFor(), s, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<ListeningAddress> start() throws IOException {
        this.start(new String[0], true);
        LogRuntimeConfig logRuntimeConfig = (LogRuntimeConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(LogRuntimeConfig.class);
        this.logFile = logRuntimeConfig.file().path().toPath();
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction = LauncherUtil.createStartedFunction();
        if (startedFunction != null) {
            LauncherUtil.waitForStartedFunction(startedFunction, this.quarkusProcess, this.waitTimeSeconds, logRuntimeConfig.file().path().toPath());
            return Optional.empty();
        }
        return LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logRuntimeConfig.file().path().toPath(), this.waitTimeSeconds);
    }

    public void start(String[] programArgs, boolean handleIo) throws IOException {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        LogRuntimeConfig logRuntimeConfig = (LogRuntimeConfig)config.getConfigMapping(LogRuntimeConfig.class);
        if (this.nativeImagePath == null) {
            this.nativeImagePath = this.guessPath(this.testClass);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.nativeImagePath);
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        if (DefaultJarLauncher.HTTP_PRESENT) {
            args.add("-Dquarkus.http.port=" + this.httpPort);
            args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
            args.add("-Dtest.url=" + LauncherUtil.generateTestUrl());
        }
        this.logFile = logRuntimeConfig.file().path().toPath();
        args.add("-Dquarkus.log.file.path=" + String.valueOf(this.logFile.toAbsolutePath()));
        args.add("-Dquarkus.log.file.enabled=true");
        args.add("-Dquarkus.log.category.\"io.quarkus\".level=INFO");
        if (this.testProfile != null) {
            args.add("-Dquarkus.profile=" + this.testProfile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        args.addAll(Arrays.asList(programArgs));
        System.out.println("Executing \"" + String.join((CharSequence)" ", args) + "\"");
        try {
            Files.deleteIfExists(this.logFile);
            if (this.logFile.getParent() != null) {
                Files.createDirectories(this.logFile.getParent(), new FileAttribute[0]);
            }
        }
        catch (FileSystemException e) {
            log.warnf("Log file %s deletion failed, could happen on Windows, we can carry on.", (Object)this.logFile);
        }
        this.quarkusProcess = handleIo ? LauncherUtil.launchProcessAndDrainIO(args, this.env) : LauncherUtil.launchProcess(args, this.env);
    }

    private void waitForStartedSupplier(Supplier<Boolean> startedSupplier, Process quarkusProcess, long waitTime) {
        long bailout = System.currentTimeMillis() + waitTime * 1000L;
        boolean started = false;
        while (System.currentTimeMillis() < bailout) {
            if (!quarkusProcess.isAlive()) {
                throw new RuntimeException("Failed to start target quarkus application, process has exited");
            }
            try {
                Thread.sleep(100L);
                if (!startedSupplier.get().booleanValue()) continue;
                started = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!started) {
            quarkusProcess.destroyForcibly();
            throw new RuntimeException("Unable to start target quarkus application " + this.waitTimeSeconds + "s");
        }
    }

    private String guessPath(Class<?> testClass) {
        ClassLoader cl = testClass.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                String applicationNativeImagePath = this.guessPath(url);
                if (applicationNativeImagePath == null) continue;
                return applicationNativeImagePath;
            }
        } else {
            URL codeSourceLocation;
            String applicationNativeImagePath;
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && (applicationNativeImagePath = this.guessPath(codeSourceLocation = codeSource.getLocation())) != null) {
                return applicationNativeImagePath;
            }
        }
        throw new RuntimeException("Unable to automatically find native image, please set the native.image.path to the native executable you wish to test");
    }

    private String guessPath(URL url) {
        if (url == null) {
            return null;
        }
        String file = null;
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test-classes/")) {
            File testClasses = new File(url.getPath());
            file = this.guessPathFromDir(testClasses.getParentFile());
        } else if (url.getProtocol().equals("file") && url.getPath().endsWith("test/")) {
            File testClasses = new File(url.getPath());
            file = this.guessPathFromDir(testClasses.getParentFile().getParentFile().getParentFile());
        } else if (url.getProtocol().equals("file") && url.getPath().contains("/target/surefire/")) {
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            File targetDir = new File(path.substring(0, index) + "/target/");
            file = this.guessPathFromDir(targetDir);
        }
        return file;
    }

    private String guessPathFromDir(File dir) {
        File[] files;
        if (dir == null) {
            return null;
        }
        if (this.configuredOutputDirectory != null) {
            dir = dir.toPath().resolve(this.configuredOutputDirectory).toFile();
        }
        if ((files = dir.listFiles()) == null) {
            return null;
        }
        for (File file : files) {
            if (!DefaultNativeImageLauncher.isNativeExecutable(file)) continue;
            DefaultNativeImageLauncher.logGuessedPath(file.getAbsolutePath());
            return file.getAbsolutePath();
        }
        return null;
    }

    private static boolean isNativeExecutable(File file) {
        if (IS_WINDOWS) {
            return file.getName().endsWith("-runner.exe");
        }
        return file.getName().endsWith("-runner");
    }

    private static void logGuessedPath(String guessedPath) {
        System.err.println("======================================================================================");
        System.err.println("  native.image.path was not set, making a guess for the correct path of native image");
        System.err.println("  guessed path: " + guessedPath);
        System.err.println("======================================================================================");
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        LauncherUtil.toStdOut(this.logFile);
        LauncherUtil.destroyProcess(this.quarkusProcess);
    }
}

