/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.jwt;

import io.quarkus.arc.Unremovable;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.security.jwt.Claim;
import io.quarkus.test.security.jwt.JwtSecurity;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class JwtTestSecurityIdentityAugmentorProducer {
    @Produces
    @Unremovable
    public TestSecurityIdentityAugmentor produce() {
        return new JwtTestSecurityIdentityAugmentor();
    }

    private static class JwtTestSecurityIdentityAugmentor
    implements TestSecurityIdentityAugmentor {
        private JwtTestSecurityIdentityAugmentor() {
        }

        public SecurityIdentity augment(final SecurityIdentity identity, Annotation[] annotations) {
            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder((SecurityIdentity)identity);
            final JwtSecurity jwtSecurity = this.findJwtSecurity(annotations);
            builder.setPrincipal((Principal)new JsonWebToken(){

                public String getName() {
                    return identity.getPrincipal().getName();
                }

                public <T> T getClaim(String claimName) {
                    if (Claims.groups.name().equals(claimName)) {
                        return (T)identity.getRoles();
                    }
                    if (jwtSecurity != null && jwtSecurity.claims() != null) {
                        for (Claim claim : jwtSecurity.claims()) {
                            if (!claim.key().equals(claimName)) continue;
                            return (T)claim.value();
                        }
                    }
                    return null;
                }

                public Set<String> getClaimNames() {
                    return null;
                }
            });
            return builder.build();
        }

        private JwtSecurity findJwtSecurity(Annotation[] annotations) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof JwtSecurity)) continue;
                return (JwtSecurity)ann;
            }
            return null;
        }
    }
}

