/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.jwt;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.security.jwt.Claim;
import io.quarkus.test.security.jwt.ClaimType;
import io.quarkus.test.security.jwt.JwtSecurity;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JwtTestSecurityIdentityAugmentor
implements TestSecurityIdentityAugmentor {
    private static Map<String, ClaimType> standardClaimTypes = Map.of(Claims.exp.name(), ClaimType.LONG, Claims.iat.name(), ClaimType.LONG, Claims.nbf.name(), ClaimType.LONG, Claims.auth_time.name(), ClaimType.LONG, Claims.email_verified.name(), ClaimType.BOOLEAN);

    public SecurityIdentity augment(final SecurityIdentity identity, Annotation[] annotations) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder((SecurityIdentity)identity);
        final JwtSecurity jwtSecurity = JwtTestSecurityIdentityAugmentor.findJwtSecurity(annotations);
        builder.setPrincipal((Principal)new JsonWebToken(){

            public String getName() {
                return identity.getPrincipal().getName();
            }

            public <T> T getClaim(String claimName) {
                if (Claims.groups.name().equals(claimName)) {
                    return (T)identity.getRoles();
                }
                if (jwtSecurity != null && jwtSecurity.claims() != null) {
                    for (Claim claim : jwtSecurity.claims()) {
                        if (!claim.key().equals(claimName)) continue;
                        return (T)JwtTestSecurityIdentityAugmentor.this.wrapValue(claim, JwtTestSecurityIdentityAugmentor.this.convertClaimValue(claim));
                    }
                }
                return null;
            }

            public Set<String> getClaimNames() {
                if (jwtSecurity != null && jwtSecurity.claims() != null) {
                    return Arrays.stream(jwtSecurity.claims()).map(Claim::key).collect(Collectors.toSet());
                }
                return Collections.emptySet();
            }
        });
        return builder.build();
    }

    private static JwtSecurity findJwtSecurity(Annotation[] annotations) {
        for (Annotation ann : annotations) {
            if (!(ann instanceof JwtSecurity)) continue;
            return (JwtSecurity)ann;
        }
        return null;
    }

    private Object wrapValue(Claim claim, Object convertedClaimValue) {
        Claims claimType = this.getClaimType(claim.key());
        if (Claims.UNKNOWN == claimType) {
            if (convertedClaimValue instanceof Long) {
                return JsonProviderHolder.jsonProvider().createValue((Number)((Long)convertedClaimValue));
            }
            if (convertedClaimValue instanceof Integer) {
                return JsonProviderHolder.jsonProvider().createValue((Number)((Integer)convertedClaimValue));
            }
            if (convertedClaimValue instanceof Boolean) {
                return (Boolean)convertedClaimValue != false ? JsonValue.TRUE : JsonValue.FALSE;
            }
        }
        return convertedClaimValue;
    }

    protected Claims getClaimType(String claimName) {
        Claims claimType;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException e) {
            claimType = Claims.UNKNOWN;
        }
        return claimType;
    }

    private Object convertClaimValue(Claim claim) {
        ClaimType type = claim.type();
        if (type == ClaimType.DEFAULT && standardClaimTypes.containsKey(claim.key())) {
            type = standardClaimTypes.get(claim.key());
        }
        return type.convert(claim.value());
    }
}

