/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.test.security.DelegateSecurityIdentityAssociation;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import java.lang.annotation.Annotation;

@Alternative
@Priority(value=3000)
@ApplicationScoped
public class TestIdentityAssociation
implements CurrentIdentityAssociation {
    private static final String DELEGATE_IDENTITY_ASSOCIATION_KEY = "test.quarkus.test-security.delegate-identity-association";
    private volatile SecurityIdentity testIdentity;
    private volatile boolean isPathBasedIdentity = false;
    private final CurrentIdentityAssociation delegate;

    TestIdentityAssociation(DelegateSecurityIdentityAssociation defaultDelegate) {
        this.delegate = TestIdentityAssociation.determineDelegate(defaultDelegate);
    }

    @PostConstruct
    public void check() {
        if (LaunchMode.current() != LaunchMode.TEST) {
            throw new RuntimeException("TestAuthController can only be used in tests");
        }
    }

    public SecurityIdentity getTestIdentity() {
        return this.testIdentity;
    }

    public TestIdentityAssociation setTestIdentity(SecurityIdentity testIdentity) {
        this.testIdentity = testIdentity;
        return this;
    }

    public void setIdentity(SecurityIdentity identity) {
        this.delegate.setIdentity(identity);
    }

    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.delegate.setIdentity(identity);
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.testIdentity == null) {
            return this.delegate.getDeferredIdentity();
        }
        return this.delegate.getDeferredIdentity().onItem().transform(underlying -> underlying.isAnonymous() && !this.isPathBasedIdentity ? this.testIdentity : underlying);
    }

    public SecurityIdentity getIdentity() {
        SecurityIdentity underlying = this.delegate.getIdentity();
        if (underlying.isAnonymous() && this.testIdentity != null && !this.isPathBasedIdentity) {
            return this.testIdentity;
        }
        return underlying;
    }

    void setPathBasedIdentity(boolean pathBasedIdentity) {
        this.isPathBasedIdentity = pathBasedIdentity;
    }

    private static CurrentIdentityAssociation determineDelegate(DelegateSecurityIdentityAssociation defaultDelegate) {
        String delegateIdentityAssociationClassName = System.getProperty(DELEGATE_IDENTITY_ASSOCIATION_KEY);
        if (delegateIdentityAssociationClassName != null) {
            Class<?> delegateClass;
            try {
                delegateClass = Thread.currentThread().getContextClassLoader().loadClass(delegateIdentityAssociationClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load " + delegateIdentityAssociationClassName, e);
            }
            CurrentIdentityAssociation delegate = (CurrentIdentityAssociation)Arc.requireContainer().select(delegateClass, new Annotation[0]).orNull();
            if (delegate == null) {
                throw new IllegalStateException("CDI bean " + delegateIdentityAssociationClassName + "is not available");
            }
            return delegate;
        }
        return defaultDelegate;
    }
}

