/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemTrustOptions;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

@ConfigGroup
public interface PemCertsConfig {
    public Optional<List<Path>> certs();

    public Optional<List<Path>> certDirs();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public boolean hasNoTrustedCertificates() {
        if (this.certs().isPresent() && !this.certs().get().isEmpty()) {
            return false;
        }
        List certDirs = this.certDirs().orElse(null);
        if (certDirs == null) return true;
        if (certDirs.isEmpty()) return true;
        Iterator iterator = certDirs.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Logger logger = Logger.getLogger(PemCertsConfig.class);
                if (!logger.isDebugEnabled()) return true;
                logger.debugf("There is %d configured directories for the trusted certificates (%s), but none of the directories contains any file", certDirs.size(), (Object)certDirs);
                return true;
            }
            Path certDir = (Path)iterator.next();
            try {
                DirectoryStream<Path> ds = PemCertsConfig.streamDirectory(certDir);
                try {
                    if (!ds.iterator().hasNext()) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (ds == null) continue;
                    ds.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close directory stream opened for certificate directory " + String.valueOf(certDir), e);
            }
        }
    }

    default public PemTrustOptions toOptions() {
        List certDirs;
        PemTrustOptions options = new PemTrustOptions();
        List certs = this.certs().orElse(null);
        if (certs != null) {
            for (Path path : certs) {
                options.addCertValue(Buffer.buffer((byte[])TlsConfigUtils.read(path)));
            }
        }
        if ((certDirs = (List)this.certDirs().orElse(null)) != null) {
            for (Path certDir : certDirs) {
                try {
                    DirectoryStream<Path> ds = PemCertsConfig.streamDirectory(certDir);
                    try {
                        for (Path cert : ds) {
                            options.addCertValue(Buffer.buffer((byte[])TlsConfigUtils.read(cert)));
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close directory stream opened for certificate directory " + String.valueOf(certDir), e);
                }
            }
        }
        if (options.getCertValues().isEmpty()) {
            throw new IllegalArgumentException("You must specify the key files and certificate files");
        }
        return options;
    }

    private static DirectoryStream<Path> streamDirectory(Path certificateDirectory) {
        if (Files.notExists(certificateDirectory, new LinkOption[0])) {
            throw new ConfigurationException("Configured certificate path does not exist:" + String.valueOf(certificateDirectory));
        }
        if (!Files.isDirectory(certificateDirectory, new LinkOption[0])) {
            throw new ConfigurationException("Path '" + String.valueOf(certificateDirectory) + "' is not a directory. Paths pointing to the certificate files can be configured with the 'quarkus.tls.trust-store.pem.certs' property instead");
        }
        try {
            return Files.newDirectoryStream(certificateDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open DirectoryStream for configured certificate path " + String.valueOf(certificateDirectory), e);
        }
    }
}

