/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsManager;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsRecorder;
import io.quarkus.vertx.http.runtime.devmode.HasDevServicesSupplier;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommand;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.validator.CommandValidator;
import org.aesh.command.validator.CommandValidatorException;

public class ConfigEditorProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void config(BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeTemplateProducer, List<ConfigDescriptionBuildItem> configDescriptionBuildItems, BuildProducer<ConsoleCommandBuildItem> consoleCommandBuildItemBuildProducer, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<DevConsoleRouteBuildItem> devConsoleRouteProducer, final Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, ConfigDescriptionsRecorder recorder) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), ConfigEditorProcessor.cleanUpAsciiDocIfNecessary(item.getDocs()), item.getDefaultValue(), ConfigEditorProcessor.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        HashSet devServicesConfig = new HashSet();
        if (devServicesLauncherConfig.isPresent()) {
            devServicesConfig.addAll(devServicesLauncherConfig.get().getConfig().keySet());
        }
        final ConfigDescriptionsManager configDescriptionsManager = recorder.manager(configDescriptions, devServicesConfig);
        consoleCommandBuildItemBuildProducer.produce((BuildItem)new ConsoleCommandBuildItem((Command)new ConfigCommandGroup(new ConfigDescriptionsManager(configDescriptions))));
        devConsoleRuntimeTemplateProducer.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("config", (Supplier)configDescriptionsManager, this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeTemplateProducer.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("hasDevServices", (Supplier)new HasDevServicesSupplier(devServicesLauncherConfig.isPresent() && devServicesLauncherConfig.get().getConfig() != null && !devServicesLauncherConfig.get().getConfig().isEmpty()), this.getClass(), curateOutcomeBuildItem));
        devConsoleRouteProducer.produce((BuildItem)new DevConsoleRouteBuildItem("add-named-group", "POST", (Handler)configDescriptionsManager));
        devConsoleRouteProducer.produce((BuildItem)new DevConsoleRouteBuildItem("config", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String action = event.request().getFormAttribute("action");
                if (action.equals("updateProperty")) {
                    String name = event.request().getFormAttribute("name");
                    String value = event.request().getFormAttribute("value");
                    String wildcard = event.request().getFormAttribute("wildcard");
                    if (!"true".equals(wildcard)) {
                        Map<String, String> values = Collections.singletonMap(name, value);
                        ConfigEditorProcessor.updateConfig(values);
                    } else {
                        String newProp = name + value;
                        configDescriptionsManager.addNamedConfigGroup(newProp);
                    }
                } else if (action.equals("copyDevServices") && devServicesLauncherConfig.isPresent()) {
                    String environment = event.request().getFormAttribute("environment");
                    String filter = event.request().getParam("filterConfigKeys");
                    List<String> configFilter = ConfigEditorProcessor.this.getConfigFilter(filter);
                    Map<String, String> autoconfig = ((DevServicesLauncherConfigResultBuildItem)devServicesLauncherConfig.get()).getConfig();
                    autoconfig = ConfigEditorProcessor.this.filterAndApplyProfile(autoconfig, configFilter, environment.toLowerCase());
                    ConfigEditorProcessor.updateConfig(autoconfig);
                } else if (action.equals("updateProperties")) {
                    String values = event.request().getFormAttribute("values");
                    ConfigEditorProcessor.setConfig(values);
                }
            }
        }));
    }

    public static String cleanUpAsciiDocIfNecessary(String docs) {
        if (docs == null || !docs.toLowerCase(Locale.ROOT).contains("@asciidoclet")) {
            return docs;
        }
        return docs.replace("@asciidoclet", "").replace("<<", "&lt;&lt;").replace(">>", "&gt;&gt;").replace("\n\n", "<p>").replace("\n", "<br>");
    }

    @BuildStep
    void handleRequests(BuildProducer<DevConsoleRouteBuildItem> devConsoleRouteProducer, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        CurrentConfig.EDITOR = ConfigEditorProcessor::updateConfig;
        devConsoleRouteProducer.produce((BuildItem)new DevConsoleRouteBuildItem("config/all", "GET", e -> e.end(Buffer.buffer((byte[])ConfigEditorProcessor.getConfig()))));
    }

    private Map<String, String> filterAndApplyProfile(Map<String, String> autoconfig, List<String> configFilter, String profile) {
        return autoconfig.entrySet().stream().filter(t -> {
            if (configFilter != null && !configFilter.isEmpty()) {
                for (String sw : configFilter) {
                    if (!((String)t.getKey()).startsWith(sw)) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }).collect(Collectors.toMap(e -> this.appendProfile(profile, (String)e.getKey()), Map.Entry::getValue));
    }

    private List<String> getConfigFilter(String filter) {
        if (filter != null && !filter.isEmpty()) {
            if (filter.contains(",")) {
                return Arrays.asList(filter.split(","));
            }
            return List.of(filter);
        }
        return Collections.EMPTY_LIST;
    }

    private String appendProfile(String profile, String originalKey) {
        return String.format("%%%s.%s", profile, originalKey);
    }

    static byte[] getConfig() {
        try {
            List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                throw new IllegalStateException("Unable to manage configurations - no resource directory found");
            }
            Path path = (Path)resourcesDir.get(0);
            Path configPath = path.resolve("application.properties");
            if (!Files.exists(configPath, new LinkOption[0])) {
                return "".getBytes();
            }
            return Files.readAllBytes(configPath);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void updateConfig(Map<String, String> values) {
        ConfigEditorProcessor.updateConfig(values, true);
    }

    public static void updateConfig(Map<String, String> values, boolean preventKill) {
        if (values != null && !values.isEmpty()) {
            try {
                Path configPath = ConfigEditorProcessor.getConfigPath();
                List<String> lines = Files.readAllLines(configPath);
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    int nameLine = -1;
                    int linesSize = lines.size();
                    for (int i = 0; i < linesSize; ++i) {
                        String line = lines.get(i);
                        if (!line.startsWith(name + "=")) continue;
                        nameLine = i;
                        break;
                    }
                    if (nameLine != -1) {
                        if (value.isEmpty()) {
                            lines.remove(nameLine);
                            continue;
                        }
                        lines.set(nameLine, name + "=" + value);
                        continue;
                    }
                    if (value.isEmpty()) continue;
                    lines.add(name + "=" + value);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                    for (String i : lines) {
                        writer.write(i);
                        writer.newLine();
                    }
                }
                if (preventKill) {
                    ConfigEditorProcessor.preventKill();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    static void setConfig(String value) {
        ConfigEditorProcessor.setConfig(value, true);
    }

    static void setConfig(String value, boolean preventKill) {
        try {
            Path configPath = ConfigEditorProcessor.getConfigPath();
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                if (value == null || value.isEmpty()) {
                    writer.newLine();
                } else {
                    writer.write(value);
                }
            }
            if (preventKill) {
                ConfigEditorProcessor.preventKill();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void preventKill() throws Exception {
        DevConsoleManager.setDoingHttpInitiatedReload((boolean)true);
        try {
            DevConsoleManager.getHotReplacementContext().doScan(true);
        }
        finally {
            DevConsoleManager.setDoingHttpInitiatedReload((boolean)false);
        }
    }

    private static Path getConfigPath() throws IOException {
        List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
        if (resourcesDir.isEmpty()) {
            throw new IllegalStateException("Unable to manage configurations - no resource directory found");
        }
        Path path = (Path)resourcesDir.get(0);
        Path configPath = path.resolve("application.properties");
        if (!Files.exists(configPath, new LinkOption[0])) {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            configPath = Files.createFile(path.resolve("application.properties"), new FileAttribute[0]);
        }
        return configPath;
    }

    public static boolean isSetByDevServices(Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, String propertyName) {
        if (devServicesLauncherConfig.isPresent()) {
            return devServicesLauncherConfig.get().getConfig().containsKey(propertyName);
        }
        return false;
    }

    public static class SetValidator
    implements CommandValidator<SetConfigCommand, CommandInvocation> {
        public void validate(SetConfigCommand command) throws CommandValidatorException {
            for (int i = 0; i < command.command.length() - 1; ++i) {
                if (command.command.charAt(i) != '=') continue;
                return;
            }
            throw new CommandValidatorException("Set command must be in the form key=value");
        }
    }

    public static class SetConfigCompleter
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerInvocation) {
            String soFar = completerInvocation.getGivenCompleteValue();
            String configKey = null;
            if (soFar.indexOf(61) != -1) {
                configKey = soFar.substring(0, soFar.indexOf(61));
            }
            SetConfigCommand command = (SetConfigCommand)completerInvocation.getCommand();
            HashSet<CallSite> possible = new HashSet<CallSite>();
            for (List j : command.configDescriptionsManager.values().values()) {
                for (ConfigDescription i : j) {
                    if (i.getDescription() == null) continue;
                    if (configKey != null && configKey.equals(i.getName())) {
                        if (i.getAllowedValues() != null && !i.getAllowedValues().isEmpty()) {
                            for (String val : i.getAllowedValues()) {
                                String value = i.getName() + "=" + val;
                                if (!value.startsWith(soFar)) continue;
                                completerInvocation.addCompleterValue(value);
                            }
                        }
                        return;
                    }
                    if (i.isWildcardEntry()) continue;
                    if (i.getName().equals(soFar)) {
                        possible.add((CallSite)((Object)(soFar + "=")));
                        continue;
                    }
                    if (!i.getName().startsWith(soFar)) continue;
                    int pos = i.getName().indexOf(46, soFar.length() + 1);
                    if (pos == -1) {
                        possible.add((CallSite)((Object)(i.getName() + "=")));
                        continue;
                    }
                    possible.add((CallSite)((Object)(i.getName().substring(0, pos) + ".")));
                }
            }
            completerInvocation.setAppendSpace(false);
            completerInvocation.addAllCompleterValues(possible);
        }
    }

    @CommandDefinition(name="set", description="Sets a config value", validator=SetValidator.class)
    public static class SetConfigCommand
    implements Command<CommandInvocation> {
        final ConfigDescriptionsManager configDescriptionsManager;
        @Argument(required=true, completer=SetConfigCompleter.class)
        private String command;

        public SetConfigCommand(ConfigDescriptionsManager configDescriptionsManager) {
            this.configDescriptionsManager = configDescriptionsManager;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            int pos = this.command.indexOf(61);
            String key = this.command.substring(0, pos);
            String value = this.command.substring(pos + 1);
            CurrentConfig.EDITOR.accept(Map.of(key, value));
            return CommandResult.SUCCESS;
        }
    }

    @GroupCommandDefinition(name="config", description="Config Editing Commands")
    public static class ConfigCommandGroup
    implements GroupCommand {
        final ConfigDescriptionsManager configDescriptionsManager;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        public boolean help;

        public ConfigCommandGroup(ConfigDescriptionsManager configDescriptionsManager) {
            this.configDescriptionsManager = configDescriptionsManager;
        }

        public List<Command> getCommands() {
            return List.of(new SetConfigCommand(this.configDescriptionsManager));
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
    }
}

