/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.spi.AdditionalSecuredMethodsBuildItem;
import io.quarkus.security.spi.AdditionalSecurityConstrainerEventPropsBuildItem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorBindingBuildItem;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorMethodsBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpAuthMechanismAnnotationBuildItem;
import io.quarkus.vertx.http.deployment.HttpSecurityPolicyBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.VertxBlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.annotation.BasicAuthentication;
import io.quarkus.vertx.http.runtime.security.annotation.FormAuthentication;
import io.quarkus.vertx.http.runtime.security.annotation.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.annotation.MTLSAuthentication;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientAuth;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class HttpSecurityProcessor {
    private static final DotName AUTH_MECHANISM_NAME = DotName.createSimple(HttpAuthenticationMechanism.class);
    private static final DotName BASIC_AUTH_MECH_NAME = DotName.createSimple(BasicAuthenticationMechanism.class);
    private static final DotName BASIC_AUTH_ANNOTATION_NAME = DotName.createSimple(BasicAuthentication.class);

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void produceNamedHttpSecurityPolicies(List<HttpSecurityPolicyBuildItem> httpSecurityPolicyBuildItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, HttpSecurityRecorder recorder) {
        if (!httpSecurityPolicyBuildItems.isEmpty()) {
            httpSecurityPolicyBuildItems.forEach(item -> syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpSecurityPolicy.class).named(HttpSecurityPolicy.class.getName() + "." + item.getName())).runtimeValue(recorder.createNamedHttpSecurityPolicy(item.getPolicySupplier(), item.getName())).addType(HttpSecurityPolicy.class)).scope(Singleton.class)).unremovable()).done()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    AdditionalBeanBuildItem initFormAuth(HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig, BuildProducer<RouteBuildItem> filterBuildItemBuildProducer) {
        if (buildTimeConfig.auth.form.enabled) {
            if (!buildTimeConfig.auth.proactive) {
                filterBuildItemBuildProducer.produce((BuildItem)RouteBuildItem.builder().route(buildTimeConfig.auth.form.postLocation).handler((Handler<RoutingContext>)recorder.formAuthPostHandler()).build());
            }
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(FormAuthenticationMechanism.class).setDefaultScope(DotNames.SINGLETON).build();
        }
        return null;
    }

    @BuildStep
    AdditionalBeanBuildItem initMtlsClientAuth(HttpBuildTimeConfig buildTimeConfig) {
        if (HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig)) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(MtlsAuthenticationMechanism.class).setDefaultScope(DotNames.SINGLETON).build();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setMtlsCertificateRoleProperties(HttpSecurityRecorder recorder, HttpConfiguration config, HttpBuildTimeConfig buildTimeConfig) {
        if (HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig)) {
            recorder.setMtlsCertificateRoleProperties(config);
        }
    }

    @BuildStep(onlyIf={IsApplicationBasicAuthRequired.class})
    void detectBasicAuthImplicitlyRequired(HttpBuildTimeConfig buildTimeConfig, BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, ApplicationIndexBuildItem applicationIndexBuildItem, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer, List<EagerSecurityInterceptorBindingBuildItem> eagerSecurityInterceptorBindings) {
        if (HttpSecurityProcessor.makeBasicAuthMechDefaultBean(buildTimeConfig)) {
            Index appIndex = applicationIndexBuildItem.getIndex();
            boolean noCustomAuthMechanismsDetected = beanRegistrationPhaseBuildItem.getContext().beans().filter(b -> b.hasType(AUTH_MECHANISM_NAME)).filter(BeanInfo::isClassBean).filter(b -> appIndex.getClassByName(b.getBeanClass()) != null).isEmpty();
            if (noCustomAuthMechanismsDetected) {
                systemPropertyProducer.produce((BuildItem)new SystemPropertyBuildItem("io.quarkus.security.http.test-if-basic-auth-implicitly-required", Boolean.TRUE.toString()));
                if (!eagerSecurityInterceptorBindings.isEmpty()) {
                    boolean basicAuthAnnotationUsed = eagerSecurityInterceptorBindings.stream().map(EagerSecurityInterceptorBindingBuildItem::getAnnotationBindings).flatMap(Arrays::stream).anyMatch(arg_0 -> ((DotName)BASIC_AUTH_ANNOTATION_NAME).equals(arg_0));
                    if (basicAuthAnnotationUsed) {
                        systemPropertyProducer.produce((BuildItem)new SystemPropertyBuildItem("io.quarkus.security.http.basic-authentication-annotation-detected", Boolean.TRUE.toString()));
                    }
                }
            }
        }
    }

    @BuildStep(onlyIf={IsApplicationBasicAuthRequired.class})
    AdditionalBeanBuildItem initBasicAuth(HttpBuildTimeConfig buildTimeConfig, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformerProducer, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        if (HttpSecurityProcessor.makeBasicAuthMechDefaultBean(buildTimeConfig)) {
            annotationsTransformerProducer.produce((BuildItem)new AnnotationsTransformerBuildItem(AnnotationsTransformer.appliedToClass().whenClass(cl -> BASIC_AUTH_MECH_NAME.equals((Object)cl.name())).thenTransform(t -> t.add(DotNames.DEFAULT_BEAN, new AnnotationValue[0]))));
        }
        if (buildTimeConfig.auth.basic.isPresent() && ((Boolean)buildTimeConfig.auth.basic.get()).booleanValue()) {
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(BasicAuthenticationMechanism.class).build();
    }

    private static boolean makeBasicAuthMechDefaultBean(HttpBuildTimeConfig buildTimeConfig) {
        return !buildTimeConfig.auth.form.enabled && !HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig) && buildTimeConfig.auth.basic.orElse(false) == false;
    }

    private static boolean applicationBasicAuthRequired(HttpBuildTimeConfig buildTimeConfig, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (buildTimeConfig.auth.basic.isPresent() && !((Boolean)buildTimeConfig.auth.basic.get()).booleanValue()) {
            return false;
        }
        return buildTimeConfig.auth.basic.orElse(false) != false || !buildTimeConfig.auth.form.enabled && !HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig) && managementInterfaceBuildTimeConfig.auth.basic.orElse(false) == false;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(HttpSecurityRecorder recorder, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Optional<HttpAuthenticationHandlerBuildItem> authenticationHandlerBuildItem, Capabilities capabilities, HttpBuildTimeConfig buildTimeConfig, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        if (!buildTimeConfig.auth.form.enabled && buildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        if (capabilities.isPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(VertxBlockingSecurityExecutor.class).setDefaultScope(DotNames.APPLICATION_SCOPED).build());
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(HttpAuthorizer.class).build());
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PathMatchingHttpSecurityPolicy.class));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.getHttpAuthenticatorHandler(authenticationHandlerBuildItem.get().handler), 200));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), 100));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createHttpAuthenticationHandler(HttpSecurityRecorder recorder, Capabilities capabilities, HttpBuildTimeConfig buildTimeConfig, BuildProducer<HttpAuthenticationHandlerBuildItem> authenticationHandlerProducer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            authenticationHandlerProducer.produce((BuildItem)new HttpAuthenticationHandlerBuildItem((RuntimeValue<HttpSecurityRecorder.AuthenticationHandler>)recorder.authenticationMechanismHandler(buildTimeConfig.auth.proactive)));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    void initializeAuthenticationHandler(Optional<HttpAuthenticationHandlerBuildItem> authenticationHandler, HttpSecurityRecorder recorder, HttpConfiguration httpConfig) {
        if (authenticationHandler.isPresent()) {
            recorder.initializeHttpAuthenticatorHandler(authenticationHandler.get().handler, httpConfig);
        }
    }

    @BuildStep
    List<HttpAuthMechanismAnnotationBuildItem> registerHttpAuthMechanismAnnotations() {
        return List.of(new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(BasicAuthentication.class), "basic"), new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(FormAuthentication.class), "form"), new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(MTLSAuthentication.class), "X509"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerAuthMechanismSelectionInterceptor(Capabilities capabilities, HttpBuildTimeConfig buildTimeConfig, BuildProducer<EagerSecurityInterceptorBindingBuildItem> bindingProducer, HttpSecurityRecorder recorder, BuildProducer<AdditionalSecuredMethodsBuildItem> additionalSecuredMethodsProducer, List<HttpAuthMechanismAnnotationBuildItem> additionalHttpAuthMechAnnotations, CombinedIndexBuildItem combinedIndexBuildItem) {
        HashSet methodsWithoutRbacAnnotations = new HashSet();
        DotName[] mechNames = (DotName[])Stream.concat(Stream.of(AUTH_MECHANISM_NAME), additionalHttpAuthMechAnnotations.stream().map(s -> s.annotationName)).flatMap(mechName -> {
            Collection instances = combinedIndexBuildItem.getIndex().getAnnotations(mechName);
            if (!instances.isEmpty()) {
                methodsWithoutRbacAnnotations.addAll(HttpSecurityProcessor.collectMethodsWithoutRbacAnnotation(HttpSecurityProcessor.collectAnnotatedMethods(instances)));
                methodsWithoutRbacAnnotations.addAll(HttpSecurityProcessor.collectClassMethodsWithoutRbacAnnotation(HttpSecurityProcessor.collectAnnotatedClasses(instances)));
                return Stream.of(mechName);
            }
            return Stream.empty();
        }).toArray(DotName[]::new);
        if (mechNames.length > 0) {
            HttpSecurityProcessor.validateAuthMechanismAnnotationUsage(capabilities, buildTimeConfig, mechNames);
            Map<String, String> knownBindingValues = additionalHttpAuthMechAnnotations.stream().collect(Collectors.toMap(item -> item.annotationName.toString(), item -> item.authMechanismScheme));
            bindingProducer.produce((BuildItem)new EagerSecurityInterceptorBindingBuildItem((Function<String, Consumer<RoutingContext>>)recorder.authMechanismSelectionInterceptorCreator(), knownBindingValues, mechNames));
            recorder.selectAuthMechanismViaAnnotation();
            if (!methodsWithoutRbacAnnotations.isEmpty()) {
                additionalSecuredMethodsProducer.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(methodsWithoutRbacAnnotations, Optional.of(List.of("**"))));
            }
        }
    }

    @BuildStep
    void collectInterceptedMethods(CombinedIndexBuildItem indexBuildItem, List<EagerSecurityInterceptorBindingBuildItem> interceptorBindings, BuildProducer<EagerSecurityInterceptorMethodsBuildItem> methodsProducer) {
        if (!interceptorBindings.isEmpty()) {
            Map<DotName, Boolean> bindingToRequiresSecCheckFlag = interceptorBindings.stream().flatMap(ib -> Arrays.stream(ib.getAnnotationBindings()).map(b -> Map.entry(b, ib.requiresSecurityCheck()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            IndexView index = indexBuildItem.getIndex();
            HashMap<MethodInfo, List<EagerSecurityInterceptorBindingBuildItem>> cache = new HashMap<MethodInfo, List<EagerSecurityInterceptorBindingBuildItem>>();
            HashMap<DotName, Map<String, List<MethodInfo>>> result = new HashMap<DotName, Map<String, List<MethodInfo>>>();
            HttpSecurityProcessor.addInterceptedEndpoints(interceptorBindings, index, AnnotationTarget.Kind.METHOD, result, cache);
            HttpSecurityProcessor.addInterceptedEndpoints(interceptorBindings, index, AnnotationTarget.Kind.CLASS, result, cache);
            if (!result.isEmpty()) {
                result.forEach((annotationBinding, bindingValueToInterceptedMethods) -> methodsProducer.produce((BuildItem)new EagerSecurityInterceptorMethodsBuildItem((Map<String, List<MethodInfo>>)bindingValueToInterceptedMethods, (DotName)annotationBinding, (Boolean)bindingToRequiresSecCheckFlag.get(annotationBinding))));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void produceEagerSecurityInterceptorStorage(HttpSecurityRecorder recorder, BuildProducer<SyntheticBeanBuildItem> producer, List<EagerSecurityInterceptorBindingBuildItem> interceptorBindings, List<EagerSecurityInterceptorMethodsBuildItem> interceptorMethods) {
        if (!interceptorMethods.isEmpty()) {
            Map<DotName, Function> bindingNameToInterceptorCreator = interceptorBindings.stream().flatMap(binding -> Arrays.stream(binding.getAnnotationBindings()).map(name -> Map.entry(name, binding.getInterceptorCreator()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<MethodInfo, RuntimeValue> methodCache = new HashMap<MethodInfo, RuntimeValue>();
            HashMap<RuntimeValue, Consumer> methodDescriptionToInterceptor = new HashMap<RuntimeValue, Consumer>();
            for (EagerSecurityInterceptorMethodsBuildItem interceptorMethod : interceptorMethods) {
                Function interceptorCreator = bindingNameToInterceptorCreator.get(interceptorMethod.interceptorBinding);
                for (Map.Entry<String, List<MethodInfo>> e : interceptorMethod.bindingValueToInterceptedMethods.entrySet()) {
                    String annotationValue = e.getKey();
                    List<MethodInfo> annotatedMethods = e.getValue();
                    Consumer interceptor = recorder.createEagerSecurityInterceptor(interceptorCreator, annotationValue);
                    for (MethodInfo method : annotatedMethods) {
                        RuntimeValue methodDescription = methodCache.computeIfAbsent(method, mi -> {
                            String[] paramTypes = (String[])mi.parameterTypes().stream().map(t -> t.name().toString()).toArray(String[]::new);
                            String className = mi.declaringClass().name().toString();
                            String methodName = mi.name();
                            return recorder.createMethodDescription(className, methodName, paramTypes);
                        });
                        methodDescriptionToInterceptor.compute(methodDescription, (desc, existingInterceptor) -> existingInterceptor == null ? interceptor : recorder.compoundSecurityInterceptor(interceptor, existingInterceptor));
                    }
                }
            }
            producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EagerSecurityInterceptorStorage.class).scope(ApplicationScoped.class)).supplier(recorder.createSecurityInterceptorStorage(methodDescriptionToInterceptor)).unremovable()).done());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void addRoutingCtxToSecurityEventsForCdiBeans(HttpSecurityRecorder recorder, Capabilities capabilities, BuildProducer<AdditionalSecurityConstrainerEventPropsBuildItem> producer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            producer.produce((BuildItem)new AdditionalSecurityConstrainerEventPropsBuildItem(recorder.createAdditionalSecEventPropsSupplier()));
        }
    }

    private static void validateAuthMechanismAnnotationUsage(Capabilities capabilities, HttpBuildTimeConfig buildTimeConfig, DotName[] annotationNames) {
        if (buildTimeConfig.auth.proactive || !capabilities.isPresent("io.quarkus.resteasy.reactive") && !capabilities.isPresent("io.quarkus.resteasy")) {
            throw new ConfigurationException("Annotations '" + Arrays.toString(annotationNames) + "' can only be used when proactive authentication is disabled and either RESTEasy Reactive or RESTEasy Classic extension is present");
        }
    }

    private static boolean isMtlsClientAuthenticationEnabled(HttpBuildTimeConfig buildTimeConfig) {
        return !ClientAuth.NONE.equals((Object)buildTimeConfig.tlsClientAuth);
    }

    private static Set<MethodInfo> collectClassMethodsWithoutRbacAnnotation(Collection<ClassInfo> classes) {
        return classes.stream().filter(c -> !SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)c)).map(ClassInfo::methods).flatMap(Collection::stream).filter(HttpSecurityProcessor::hasProperEndpointModifiers).filter(m -> !SecurityTransformerUtils.hasSecurityAnnotation((MethodInfo)m)).collect(Collectors.toSet());
    }

    private static Set<MethodInfo> collectMethodsWithoutRbacAnnotation(Collection<MethodInfo> methods) {
        return methods.stream().filter(m -> !SecurityTransformerUtils.hasSecurityAnnotation((MethodInfo)m)).collect(Collectors.toSet());
    }

    private static Set<ClassInfo> collectAnnotatedClasses(Collection<AnnotationInstance> instances) {
        return instances.stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).collect(Collectors.toSet());
    }

    private static Set<MethodInfo> collectAnnotatedMethods(Collection<AnnotationInstance> instances) {
        return instances.stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.METHOD).map(AnnotationTarget::asMethod).collect(Collectors.toSet());
    }

    private static boolean hasProperEndpointModifiers(MethodInfo info) {
        if (info.isSynthetic()) {
            return false;
        }
        if (!Modifier.isPublic(info.flags())) {
            return false;
        }
        if (info.isConstructor()) {
            return false;
        }
        return !Modifier.isStatic(info.flags());
    }

    private static void addInterceptedEndpoints(List<EagerSecurityInterceptorBindingBuildItem> interceptorBindings, IndexView index, AnnotationTarget.Kind appliesTo, Map<DotName, Map<String, List<MethodInfo>>> result, Map<MethodInfo, List<EagerSecurityInterceptorBindingBuildItem>> cache) {
        for (EagerSecurityInterceptorBindingBuildItem interceptorBinding : interceptorBindings) {
            for (DotName annotationBinding : interceptorBinding.getAnnotationBindings()) {
                HashMap<String, List<MethodInfo>> bindingValueToInterceptedMethods = new HashMap<String, List<MethodInfo>>();
                for (AnnotationInstance annotation : index.getAnnotations(annotationBinding)) {
                    if (annotation.target().kind() != appliesTo) continue;
                    if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                        for (MethodInfo method : annotation.target().asClass().methods()) {
                            boolean interceptorBindingNotAppliedOnMethodLevel;
                            if (!HttpSecurityProcessor.hasProperEndpointModifiers(method) || !(interceptorBindingNotAppliedOnMethodLevel = !cache.containsKey(method) || !cache.get(method).contains((Object)interceptorBinding))) continue;
                            HttpSecurityProcessor.addInterceptedEndpoint(method, annotation, annotationBinding, bindingValueToInterceptedMethods, interceptorBinding);
                        }
                        continue;
                    }
                    MethodInfo mi = annotation.target().asMethod();
                    List appliedBindings = cache.computeIfAbsent(mi, a -> new ArrayList());
                    if (appliedBindings.contains((Object)interceptorBinding)) {
                        throw new RuntimeException("Only one of the '%s' annotations can be applied on the '%s' method".formatted(interceptorBinding.getAnnotationBindings(), mi.declaringClass().name() + "#" + mi));
                    }
                    appliedBindings.add(interceptorBinding);
                    HttpSecurityProcessor.addInterceptedEndpoint(mi, annotation, annotationBinding, bindingValueToInterceptedMethods, interceptorBinding);
                }
                if (bindingValueToInterceptedMethods.isEmpty()) continue;
                result.compute(annotationBinding, (key, existingMap) -> {
                    if (existingMap == null) {
                        return bindingValueToInterceptedMethods;
                    }
                    bindingValueToInterceptedMethods.forEach((annotationValue, methods) -> existingMap.computeIfAbsent(annotationValue, a -> new ArrayList()).addAll(methods));
                    return existingMap;
                });
            }
        }
    }

    private static void addInterceptedEndpoint(MethodInfo classEndpoint, AnnotationInstance annotationInstance, DotName annotation, Map<String, List<MethodInfo>> bindingValueToInterceptedMethods, EagerSecurityInterceptorBindingBuildItem interceptorBinding) {
        bindingValueToInterceptedMethods.computeIfAbsent(interceptorBinding.getBindingValue(annotationInstance, annotation, classEndpoint), s -> new ArrayList()).add(classEndpoint);
    }

    static final class HttpAuthenticationHandlerBuildItem
    extends SimpleBuildItem {
        private final RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler;

        private HttpAuthenticationHandlerBuildItem(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler) {
            this.handler = handler;
        }
    }

    static class IsApplicationBasicAuthRequired
    implements BooleanSupplier {
        private final boolean required;

        public IsApplicationBasicAuthRequired(HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
            this.required = HttpSecurityProcessor.applicationBasicAuthRequired(httpBuildTimeConfig, managementInterfaceBuildTimeConfig);
        }

        @Override
        public boolean getAsBoolean() {
            return this.required;
        }
    }
}

