/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.config.ConfigDescription;
import io.quarkus.devui.runtime.config.ConfigDescriptionBean;
import io.quarkus.devui.runtime.config.ConfigDevUIRecorder;
import io.quarkus.devui.runtime.config.ConfigJsonRPCService;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import jakarta.inject.Singleton;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigurationProcessor {
    private static final Pattern codePattern = Pattern.compile("(\\{@code )([^}]+)(\\})");
    private static final Pattern linkPattern = Pattern.compile("(\\{@link )([^}]+)(\\})");
    private static final String NAMESPACE = "devui-configuration";

    @BuildStep(onlyIf={IsDevelopment.class})
    InternalPageBuildItem createConfigurationPages(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        InternalPageBuildItem configurationPages = new InternalPageBuildItem("Configuration", 20);
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Form Editor")).icon("font-awesome-solid:sliders")).componentLink("qwc-configuration.js"));
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Source Editor")).icon("font-awesome-solid:code")).componentLink("qwc-configuration-editor.js"));
        configurationPages.addBuildTimeData("allConfiguration", new ArrayList());
        return configurationPages;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerConfigs(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, ConfigDevUIRecorder recorder) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), ConfigurationProcessor.formatJavadoc(ConfigurationProcessor.cleanUpAsciiDocIfNecessary(item.getDocs())), item.getDefaultValue(), ConfigurationProcessor.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        HashSet devServicesConfig = new HashSet();
        if (devServicesLauncherConfig.isPresent()) {
            devServicesConfig.addAll(devServicesLauncherConfig.get().getConfig().keySet());
        }
        recorder.registerConfigs(configDescriptions, devServicesConfig);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerJsonRpcService(BuildProducer<JsonRPCProvidersBuildItem> jsonRPCProvidersProducer, BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, ConfigDevUIRecorder recorder, CuratedApplicationShutdownBuildItem shutdown) {
        BuildTimeActionBuildItem configActions = new BuildTimeActionBuildItem(NAMESPACE);
        configActions.addAction("updateProperty", map -> {
            Map<String, String> values = Collections.singletonMap((String)map.get("name"), (String)map.get("value"));
            ConfigurationProcessor.updateConfig(values);
            return true;
        });
        configActions.addAction("updateProperties", map -> {
            String type = (String)map.get("type");
            if (type.equalsIgnoreCase("properties")) {
                String content = (String)map.get("content");
                Properties p = new Properties();
                StringReader sr = new StringReader(content);
                try {
                    p.load(sr);
                    ConfigurationProcessor.setConfig(content);
                    Boolean bl = true;
                    sr.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            sr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            }
            return false;
        });
        buildTimeActionProducer.produce((BuildItem)configActions);
        syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ConfigDescriptionBean.class).unremovable()).supplier(recorder.configDescriptionBean()).scope(Singleton.class)).setRuntimeInit().done());
        CurrentConfig.EDITOR = ConfigurationProcessor::updateConfig;
        shutdown.addCloseTask(new Runnable(){

            @Override
            public void run() {
                CurrentConfig.EDITOR = null;
                CurrentConfig.CURRENT = Collections.emptyList();
            }
        }, true);
        jsonRPCProvidersProducer.produce((BuildItem)new JsonRPCProvidersBuildItem(NAMESPACE, ConfigJsonRPCService.class));
    }

    private static String formatJavadoc(String val) {
        if (val == null) {
            return val;
        }
        val = codePattern.matcher(val).replaceAll("<code>$2</code>");
        val = linkPattern.matcher(val).replaceAll("<code>$2</code>");
        val = val.lines().filter(s -> !s.startsWith("@see")).collect(Collectors.joining("\n"));
        val = val.replace("@deprecated", "<br><strong>Deprecated</strong>");
        return val;
    }

    private static String cleanUpAsciiDocIfNecessary(String docs) {
        if (docs == null || !docs.toLowerCase(Locale.ROOT).contains("@asciidoclet")) {
            return docs;
        }
        return docs.replace("@asciidoclet", "").replace("<<", "&lt;&lt;").replace(">>", "&gt;&gt;").replace("\n\n", "<p>").replace("\n", "<br>");
    }

    private static boolean isSetByDevServices(Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, String propertyName) {
        if (devServicesLauncherConfig.isPresent()) {
            return devServicesLauncherConfig.get().getConfig().containsKey(propertyName);
        }
        return false;
    }

    public static void updateConfig(Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            try {
                Path configPath = ConfigurationProcessor.getConfigPath();
                List<String> lines = Files.readAllLines(configPath);
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    int nameLine = -1;
                    int linesSize = lines.size();
                    for (int i = 0; i < linesSize; ++i) {
                        String line = lines.get(i);
                        if (!line.startsWith(name + "=")) continue;
                        nameLine = i;
                        break;
                    }
                    if (nameLine != -1) {
                        if (value.isEmpty()) {
                            lines.remove(nameLine);
                            continue;
                        }
                        lines.set(nameLine, name + "=" + value);
                        continue;
                    }
                    if (value.isEmpty()) continue;
                    lines.add(name + "=" + value);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                    for (String i : lines) {
                        writer.write(i);
                        writer.newLine();
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private static void setConfig(String value) {
        try {
            Path configPath = ConfigurationProcessor.getConfigPath();
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                if (value == null || value.isEmpty()) {
                    writer.newLine();
                } else {
                    writer.write(value);
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Path getConfigPath() throws IOException {
        List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
        if (resourcesDir.isEmpty()) {
            throw new IllegalStateException("Unable to manage configurations - no resource directory found");
        }
        Path path = (Path)resourcesDir.get(0);
        Path configPath = path.resolve("application.properties");
        if (!Files.exists(configPath, new LinkOption[0])) {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            configPath = Files.createFile(path.resolve("application.properties"), new FileAttribute[0]);
        }
        return configPath;
    }
}

