/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class WebSocketLogHandler
extends ExtHandler {
    private final LinkedBlockingQueue<ExtLogRecord> history;
    private static final Map<String, ServerWebSocket> SESSIONS = new ConcurrentHashMap<String, ServerWebSocket>();

    public WebSocketLogHandler() {
        this(50);
    }

    public WebSocketLogHandler(int size) {
        this.history = new LinkedBlockingQueue(size);
        this.setFormatter((Formatter)((Object)new JsonFormatter()));
    }

    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.isLoggable((LogRecord)record)) {
            this.recordHistory(record);
            this.streamToWebSocket(record);
        }
    }

    public void addSession(String id, ServerWebSocket session) {
        SESSIONS.put(id, session);
        if (this.hasHistory()) {
            List<ExtLogRecord> history = this.getHistory();
            for (ExtLogRecord lr : history) {
                this.streamToWebSocket(lr);
            }
        }
    }

    public void removeSession(String id) {
        if (SESSIONS.containsKey(id)) {
            SESSIONS.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordHistory(ExtLogRecord record) {
        WebSocketLogHandler webSocketLogHandler = this;
        synchronized (webSocketLogHandler) {
            try {
                if (this.history.remainingCapacity() == 0) {
                    this.history.take();
                }
                this.history.add(record);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void streamToWebSocket(ExtLogRecord record) {
        if (!SESSIONS.isEmpty()) {
            String message = this.getFormatter().format((LogRecord)record);
            for (ServerWebSocket session : SESSIONS.values()) {
                try {
                    session.writeTextMessage(message);
                }
                catch (Throwable ex) {
                    session.close();
                }
            }
        }
    }

    public boolean hasHistory() {
        return !this.history.isEmpty();
    }

    public List<ExtLogRecord> getHistory() {
        return new ArrayList<ExtLogRecord>(this.history);
    }

    public void clearHistory() {
        this.history.clear();
    }
}

