/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Map;

public class VertxConfigBuilder
implements ConfigBuilder {
    private static final String QUARKUS_HTTP_HOST = "quarkus.http.host";
    private static final String ALL_INTERFACES = "0.0.0.0";

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        if (builder.getDefaultValues().get(QUARKUS_HTTP_HOST) == null) {
            if (LaunchMode.isRemoteDev()) {
                builder.withDefaultValue(QUARKUS_HTTP_HOST, ALL_INTERFACES);
            } else {
                builder.withDefaultValue(QUARKUS_HTTP_HOST, LaunchMode.current().isDevOrTest() && !this.isWSL() ? "localhost" : ALL_INTERFACES);
            }
        }
        return builder;
    }

    private boolean isWSL() {
        Map<String, String> sysEnv = System.getenv();
        return sysEnv.containsKey("IS_WSL") || sysEnv.containsKey("WSL_DISTRO_NAME");
    }
}

