/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.PolicyConfig;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.AuthenticatedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.quarkus.vertx.http.runtime.security.PermitSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AbstractPathMatchingHttpSecurityPolicy {
    private static final String PATH_MATCHING_POLICY_FOUND = AbstractPathMatchingHttpSecurityPolicy.class.getName() + ".POLICY_FOUND";
    private final ImmutablePathMatcher<List<HttpMatcher>> pathMatcher;
    private final List<ImmutablePathMatcher<List<HttpMatcher>>> sharedPermissionsPathMatchers;
    private final boolean hasNoPermissions;

    public AbstractPathMatchingHttpSecurityPolicy(Map<String, PolicyMappingConfig> permissions, Map<String, PolicyConfig> rolePolicy, String rootPath, Instance<HttpSecurityPolicy> installedPolicies, PolicyMappingConfig.AppliesTo appliesTo) {
        boolean hasNoPermissions = true;
        Map<String, HttpSecurityPolicy> namedHttpSecurityPolicies = AbstractPathMatchingHttpSecurityPolicy.toNamedHttpSecPolicies(rolePolicy, installedPolicies);
        ArrayList<ImmutablePathMatcher<List<HttpMatcher>>> sharedPermsMatchers = new ArrayList<ImmutablePathMatcher<List<HttpMatcher>>>();
        ImmutablePathMatcher.ImmutablePathMatcherBuilder<List<HttpMatcher>> builder = ImmutablePathMatcher.builder().handlerAccumulator(List::addAll).rootPath(rootPath);
        for (PolicyMappingConfig policyMappingConfig : permissions.values()) {
            if (appliesTo != policyMappingConfig.appliesTo) continue;
            if (hasNoPermissions) {
                hasNoPermissions = false;
            }
            if (policyMappingConfig.shared) {
                ImmutablePathMatcher.ImmutablePathMatcherBuilder<List<HttpMatcher>> builder1 = ImmutablePathMatcher.builder().handlerAccumulator(List::addAll).rootPath(rootPath);
                AbstractPathMatchingHttpSecurityPolicy.addPermissionToPathMatcher(namedHttpSecurityPolicies, policyMappingConfig, builder1);
                sharedPermsMatchers.add(builder1.build());
                continue;
            }
            AbstractPathMatchingHttpSecurityPolicy.addPermissionToPathMatcher(namedHttpSecurityPolicies, policyMappingConfig, builder);
        }
        this.hasNoPermissions = hasNoPermissions;
        this.sharedPermissionsPathMatchers = sharedPermsMatchers.isEmpty() ? null : List.copyOf(sharedPermsMatchers);
        this.pathMatcher = builder.build();
    }

    public String getAuthMechanismName(RoutingContext routingContext) {
        if (this.sharedPermissionsPathMatchers != null) {
            for (ImmutablePathMatcher<List<HttpMatcher>> matcher : this.sharedPermissionsPathMatchers) {
                String authMechanismName = AbstractPathMatchingHttpSecurityPolicy.getAuthMechanismName(routingContext, matcher);
                if (authMechanismName == null) continue;
                return authMechanismName;
            }
        }
        return AbstractPathMatchingHttpSecurityPolicy.getAuthMechanismName(routingContext, this.pathMatcher);
    }

    public boolean hasNoPermissions() {
        return this.hasNoPermissions;
    }

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext routingContext, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        ArrayList<HttpSecurityPolicy> permissionCheckers;
        if (this.sharedPermissionsPathMatchers == null) {
            permissionCheckers = AbstractPathMatchingHttpSecurityPolicy.findPermissionCheckers(routingContext, this.pathMatcher);
        } else {
            permissionCheckers = new ArrayList();
            for (ImmutablePathMatcher<List<HttpMatcher>> matcher : this.sharedPermissionsPathMatchers) {
                permissionCheckers.addAll(AbstractPathMatchingHttpSecurityPolicy.findPermissionCheckers(routingContext, matcher));
            }
            permissionCheckers.addAll(AbstractPathMatchingHttpSecurityPolicy.findPermissionCheckers(routingContext, this.pathMatcher));
        }
        return this.doPermissionCheck(routingContext, identity, 0, null, permissionCheckers, requestContext);
    }

    private Uni<HttpSecurityPolicy.CheckResult> doPermissionCheck(final RoutingContext routingContext, final Uni<SecurityIdentity> identity, final int index, final SecurityIdentity augmentedIdentity, final List<HttpSecurityPolicy> permissionCheckers, final HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        if (index == permissionCheckers.size()) {
            if (index > 0) {
                routingContext.put(PATH_MATCHING_POLICY_FOUND, (Object)true);
            }
            return Uni.createFrom().item((Object)new HttpSecurityPolicy.CheckResult(true, augmentedIdentity));
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        return res.checkPermission(routingContext, identity, requestContext).flatMap((Function)new Function<HttpSecurityPolicy.CheckResult, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

            @Override
            public Uni<? extends HttpSecurityPolicy.CheckResult> apply(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.DENY);
                }
                if (checkResult.getAugmentedIdentity() != null) {
                    return AbstractPathMatchingHttpSecurityPolicy.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)Uni.createFrom().item((Object)checkResult.getAugmentedIdentity()), index + 1, checkResult.getAugmentedIdentity(), permissionCheckers, requestContext);
                }
                return AbstractPathMatchingHttpSecurityPolicy.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)identity, index + 1, augmentedIdentity, permissionCheckers, requestContext);
            }
        });
    }

    private static String getAuthMechanismName(RoutingContext routingContext, ImmutablePathMatcher<List<HttpMatcher>> pathMatcher) {
        ImmutablePathMatcher.PathMatch<List<HttpMatcher>> toCheck = pathMatcher.match(routingContext.normalizedPath());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return null;
        }
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.authMechanism == null) continue;
            return i.authMechanism;
        }
        return null;
    }

    private static void addPermissionToPathMatcher(Map<String, HttpSecurityPolicy> permissionCheckers, PolicyMappingConfig policyMappingConfig, ImmutablePathMatcher.ImmutablePathMatcherBuilder<List<HttpMatcher>> builder) {
        HttpSecurityPolicy checker = permissionCheckers.get(policyMappingConfig.policy);
        if (checker == null) {
            throw new RuntimeException("Unable to find HTTP security policy " + policyMappingConfig.policy);
        }
        if (policyMappingConfig.enabled.orElse(Boolean.TRUE).booleanValue()) {
            for (String path : policyMappingConfig.paths.orElse(Collections.emptyList())) {
                HttpMatcher m = new HttpMatcher(policyMappingConfig.authMechanism.orElse(null), new HashSet<String>(policyMappingConfig.methods.orElse(Collections.emptyList())), checker);
                ArrayList<HttpMatcher> perms = new ArrayList<HttpMatcher>();
                perms.add(m);
                builder.addPath(path, perms);
            }
        }
    }

    private static List<HttpSecurityPolicy> findPermissionCheckers(RoutingContext context, ImmutablePathMatcher<List<HttpMatcher>> pathMatcher) {
        ImmutablePathMatcher.PathMatch<List<HttpMatcher>> toCheck = pathMatcher.match(context.normalizedPath());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpSecurityPolicy> methodMatch = new ArrayList<HttpSecurityPolicy>();
        ArrayList<HttpSecurityPolicy> noMethod = new ArrayList<HttpSecurityPolicy>();
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.methods == null || i.methods.isEmpty()) {
                noMethod.add(i.checker);
                continue;
            }
            if (!i.methods.contains(context.request().method().toString())) continue;
            methodMatch.add(i.checker);
        }
        if (!methodMatch.isEmpty()) {
            return methodMatch;
        }
        if (!noMethod.isEmpty()) {
            return noMethod;
        }
        return Collections.singletonList(DenySecurityPolicy.INSTANCE);
    }

    static boolean policyApplied(RoutingContext routingContext) {
        return routingContext.get(PATH_MATCHING_POLICY_FOUND) != null;
    }

    private static Map<String, HttpSecurityPolicy> toNamedHttpSecPolicies(Map<String, PolicyConfig> rolePolicies, Instance<HttpSecurityPolicy> installedPolicies) {
        HashMap<String, HttpSecurityPolicy> namedPolicies = new HashMap<String, HttpSecurityPolicy>();
        for (Instance.Handle handle : installedPolicies.handles()) {
            HttpSecurityPolicy policy;
            if (handle.getBean().getBeanClass().getSuperclass() == AbstractPathMatchingHttpSecurityPolicy.class || (policy = (HttpSecurityPolicy)handle.get()).name() == null) continue;
            if (policy.name().isBlank()) {
                throw new ConfigurationException("HTTP Security policy '" + policy + "' name must not be blank");
            }
            namedPolicies.put(policy.name(), policy);
        }
        for (Map.Entry entry : rolePolicies.entrySet()) {
            HashMap<String, Set<Permission>> roleToPermissions;
            PolicyConfig policyConfig = (PolicyConfig)entry.getValue();
            if (policyConfig.permissions.isEmpty()) {
                roleToPermissions = null;
            } else {
                roleToPermissions = new HashMap<String, Set<Permission>>();
                for (Map.Entry<String, List<String>> roleToPermissionStr : policyConfig.permissions.entrySet()) {
                    HashMap<String, PermissionToActions> cache = new HashMap<String, PermissionToActions>();
                    String role = roleToPermissionStr.getKey();
                    for (String permissionToAction : roleToPermissionStr.getValue()) {
                        AbstractPathMatchingHttpSecurityPolicy.addPermissionToAction(cache, role, permissionToAction);
                    }
                    HashSet<Object> permissions = new HashSet<Object>();
                    for (PermissionToActions helper : cache.values()) {
                        if (StringPermission.class.getName().equals(policyConfig.permissionClass)) {
                            permissions.add(new StringPermission(helper.permissionName, helper.actions.toArray(new String[0])));
                            continue;
                        }
                        permissions.add(AbstractPathMatchingHttpSecurityPolicy.customPermissionCreator(policyConfig, helper));
                    }
                    roleToPermissions.put(role, Set.copyOf(permissions));
                }
            }
            namedPolicies.put((String)entry.getKey(), new RolesAllowedHttpSecurityPolicy(policyConfig.rolesAllowed, roleToPermissions, policyConfig.roles));
        }
        namedPolicies.put("deny", new DenySecurityPolicy());
        namedPolicies.put("permit", new PermitSecurityPolicy());
        namedPolicies.put("authenticated", new AuthenticatedHttpSecurityPolicy());
        return namedPolicies;
    }

    private static boolean acceptsActions(String permissionClassStr) {
        boolean acceptsActions;
        Class<?> permissionClass = AbstractPathMatchingHttpSecurityPolicy.loadClass(permissionClassStr);
        if (permissionClass.getConstructors().length != 1) {
            throw new ConfigurationException(String.format("Permission class '%s' must have exactly one constructor", permissionClass));
        }
        Constructor<?> constructor = permissionClass.getConstructors()[0];
        if (constructor.getParameterCount() == 0 || constructor.getParameterTypes()[0] != String.class) {
            throw new ConfigurationException(String.format("Permission class '%s' constructor first parameter must be '%s' (permission name)", permissionClass, String.class.getName()));
        }
        if (constructor.getParameterCount() == 1) {
            acceptsActions = false;
        } else {
            if (constructor.getParameterCount() == 2) {
                if (constructor.getParameterTypes()[1] != String[].class) {
                    throw new ConfigurationException(String.format("Permission class '%s' constructor second parameter must be '%s' array", permissionClass, String.class.getName()));
                }
            } else {
                throw new ConfigurationException(String.format("Permission class '%s' constructor must accept either one parameter (String permissionName), or two parameters (String permissionName, String[] actions)", permissionClass));
            }
            acceptsActions = true;
        }
        return acceptsActions;
    }

    private static void addPermissionToAction(Map<String, PermissionToActions> cache, String role, String permissionToAction) {
        String action;
        String permissionName;
        if (permissionToAction.contains(":")) {
            String[] permToActions = permissionToAction.split(":");
            if (permToActions.length != 2) {
                throw new ConfigurationException(String.format("Invalid permission format '%s', please use exactly one permission to action separator", permissionToAction));
            }
            permissionName = permToActions[0].trim();
            action = permToActions[1].trim();
        } else {
            permissionName = permissionToAction.trim();
            action = null;
        }
        if (permissionName.isEmpty()) {
            throw new ConfigurationException(String.format("Invalid permission name '%s' for role '%s'", permissionToAction, role));
        }
        cache.computeIfAbsent(permissionName, new Function<String, PermissionToActions>(){

            @Override
            public PermissionToActions apply(String s) {
                return new PermissionToActions(s);
            }
        }).addAction(action);
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class '" + className + "' for creating permission", e);
        }
    }

    private static Permission customPermissionCreator(PolicyConfig policyConfig, PermissionToActions helper) {
        try {
            Constructor<?> constructor = AbstractPathMatchingHttpSecurityPolicy.loadClass(policyConfig.permissionClass).getConstructors()[0];
            if (AbstractPathMatchingHttpSecurityPolicy.acceptsActions(policyConfig.permissionClass)) {
                return (Permission)constructor.newInstance(helper.permissionName, helper.actions.toArray(new String[0]));
            }
            return (Permission)constructor.newInstance(helper.permissionName);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to create Permission - class '%s', name '%s', actions '%s'", policyConfig.permissionClass, helper.permissionName, Arrays.toString(helper.actions.toArray(new String[0]))), e);
        }
    }

    static class HttpMatcher {
        final String authMechanism;
        final Set<String> methods;
        final HttpSecurityPolicy checker;

        HttpMatcher(String authMechanism, Set<String> methods, HttpSecurityPolicy checker) {
            this.methods = methods;
            this.checker = checker;
            this.authMechanism = authMechanism;
        }
    }

    private static final class PermissionToActions {
        private final String permissionName;
        private final Set<String> actions;

        private PermissionToActions(String permissionName) {
            this.permissionName = permissionName;
            this.actions = new HashSet<String>();
        }

        private void addAction(String action) {
            if (action != null) {
                this.actions.add(action);
            }
        }
    }
}

