/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import java.util.Collection;
import java.util.List;

public class ForwardingProxyOptions {
    public final boolean proxyAddressForwarding;
    final boolean allowForwarded;
    final boolean allowXForwarded;
    final boolean enableForwardedHost;
    final boolean enableForwardedPrefix;
    final AsciiString forwardedHostHeader;
    final AsciiString forwardedPrefixHeader;
    final boolean strictForwardedControl;
    final ProxyConfig.ForwardedPrecedence forwardedPrecedence;
    public final TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder;
    final boolean enableTrustedProxyHeader;

    public ForwardingProxyOptions(boolean proxyAddressForwarding, boolean allowForwarded, boolean allowXForwarded, boolean enableForwardedHost, boolean enableTrustedProxyHeader, AsciiString forwardedHostHeader, boolean enableForwardedPrefix, boolean strictForwardedControl, ProxyConfig.ForwardedPrecedence forwardedPrecedence, AsciiString forwardedPrefixHeader, TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder) {
        this.proxyAddressForwarding = proxyAddressForwarding;
        this.allowForwarded = allowForwarded;
        this.allowXForwarded = allowXForwarded;
        this.enableForwardedHost = enableForwardedHost;
        this.enableForwardedPrefix = enableForwardedPrefix;
        this.forwardedHostHeader = forwardedHostHeader;
        this.forwardedPrefixHeader = forwardedPrefixHeader;
        this.strictForwardedControl = strictForwardedControl;
        this.forwardedPrecedence = forwardedPrecedence;
        this.trustedProxyCheckBuilder = trustedProxyCheckBuilder;
        this.enableTrustedProxyHeader = enableTrustedProxyHeader;
    }

    public static ForwardingProxyOptions from(ProxyConfig proxy) {
        boolean proxyAddressForwarding = proxy.proxyAddressForwarding;
        boolean allowForwarded = proxy.allowForwarded;
        boolean allowXForwarded = proxy.allowXForwarded.orElse(!allowForwarded);
        boolean enableForwardedHost = proxy.enableForwardedHost;
        boolean enableForwardedPrefix = proxy.enableForwardedPrefix;
        boolean enableTrustedProxyHeader = proxy.enableTrustedProxyHeader;
        boolean strictForwardedControl = proxy.strictForwardedControl;
        ProxyConfig.ForwardedPrecedence forwardedPrecedence = proxy.forwardedPrecedence;
        AsciiString forwardedPrefixHeader = AsciiString.cached((String)proxy.forwardedPrefixHeader);
        AsciiString forwardedHostHeader = AsciiString.cached((String)proxy.forwardedHostHeader);
        List<TrustedProxyCheck.TrustedProxyCheckPart> parts = proxy.trustedProxies.isPresent() ? List.copyOf((Collection)proxy.trustedProxies.get()) : List.of();
        TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder = !allowXForwarded && !allowForwarded || parts.isEmpty() ? null : TrustedProxyCheck.TrustedProxyCheckBuilder.builder(parts);
        return new ForwardingProxyOptions(proxyAddressForwarding, allowForwarded, allowXForwarded, enableForwardedHost, enableTrustedProxyHeader, forwardedHostHeader, enableForwardedPrefix, strictForwardedControl, forwardedPrecedence, forwardedPrefixHeader, proxyCheckBuilder);
    }
}

