/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import java.util.Arrays;

public class ImmutableSubstringMap<V> {
    private static final int ALL_BUT_LAST_BIT = -2;
    private final Object[] table;

    ImmutableSubstringMap(Object[] table) {
        this.table = Arrays.copyOf(table, table.length);
    }

    public SubstringMatch<V> get(String key, int length) {
        int pos;
        if (key.length() < length) {
            throw new IllegalArgumentException();
        }
        int hash = ImmutableSubstringMap.hash(key, length);
        int start = pos = ImmutableSubstringMap.tablePos(this.table, hash);
        while (this.table[pos] != null) {
            if (ImmutableSubstringMap.doEquals((String)this.table[pos], key, length)) {
                SubstringMatch match = (SubstringMatch)this.table[pos + 1];
                if (match == null) {
                    return null;
                }
                if (match.hasSubPathMatcher) {
                    String nextPath;
                    ImmutablePathMatcher.PathMatch subMatch;
                    int nextPathSegmentIdx;
                    if (key.length() > match.key.length() + 1 && (nextPathSegmentIdx = key.indexOf(47, match.key.length() + 1)) != -1 && (subMatch = match.subPathMatcher.match(nextPath = key.substring(nextPathSegmentIdx))).getValue() != null) {
                        return subMatch.getValue();
                    }
                    if (match.value == null) {
                        return null;
                    }
                }
                return match;
            }
            if ((pos += 2) >= this.table.length) {
                pos = 0;
            }
            if (pos != start) continue;
            return null;
        }
        return null;
    }

    static int tablePos(Object[] table, int hash) {
        return hash & table.length - 1 & 0xFFFFFFFE;
    }

    static boolean doEquals(String s1, String s2, int length) {
        if (s1.length() != length || s2.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static int hash(String value, int length) {
        if (length == 0) {
            return 0;
        }
        int h = 0;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + value.charAt(i);
        }
        return h;
    }

    public static final class SubstringMatch<V> {
        private final String key;
        private final V value;
        private final boolean hasSubPathMatcher;
        private final ImmutablePathMatcher<SubstringMatch<V>> subPathMatcher;

        SubstringMatch(String key, V value) {
            this.key = key;
            this.value = value;
            this.subPathMatcher = null;
            this.hasSubPathMatcher = false;
        }

        SubstringMatch(String key, V value, ImmutablePathMatcher<SubstringMatch<V>> subPathMatcher) {
            this.key = key;
            this.value = value;
            this.subPathMatcher = subPathMatcher;
            this.hasSubPathMatcher = subPathMatcher != null;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        boolean hasSubPathMatcher() {
            return this.hasSubPathMatcher;
        }
    }
}

