/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Singleton
public class HttpAuthenticator {
    private static final Logger log = Logger.getLogger(HttpAuthenticator.class);
    private final IdentityProviderManager identityProviderManager;
    private final HttpAuthenticationMechanism[] mechanisms;
    private final SecurityEventHelper<AuthenticationSuccessEvent, AuthenticationFailureEvent> securityEventHelper;

    public HttpAuthenticator(IdentityProviderManager identityProviderManager, Event<AuthenticationFailureEvent> authFailureEvent, Event<AuthenticationSuccessEvent> authSuccessEvent, BeanManager beanManager, HttpBuildTimeConfig httpBuildTimeConfig, Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, Instance<IdentityProvider<?>> providers, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled) {
        this.securityEventHelper = new SecurityEventHelper(authSuccessEvent, authFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_FAILURE, beanManager, securityEventsEnabled);
        this.identityProviderManager = identityProviderManager;
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : httpAuthenticationMechanism) {
            if (mechanism.getCredentialTypes().isEmpty()) {
                log.debugf("HttpAuthenticationMechanism '%s' provided no required credential types, therefore it needs to be able to perform authentication without any IdentityProvider", (Object)mechanism.getClass().getName());
                mechanisms.add(mechanism);
                continue;
            }
            boolean found = false;
            for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
                for (IdentityProvider i : providers) {
                    if (!i.getRequestType().equals(mechType)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) {
                mechanisms.add(mechanism);
                continue;
            }
            if (BasicAuthenticationMechanism.class.equals(mechanism.getClass()) && httpBuildTimeConfig.auth.basic.isEmpty()) {
                log.debug((Object)"BasicAuthenticationMechanism has been enabled because no other authentication mechanism has been\ndetected, but there is no IdentityProvider based on username and password. Please use\none of supported extensions if you plan to use the mechanism.\nFor more information go to the https://quarkus.io/guides/security-basic-authentication-howto.\n");
                continue;
            }
            throw new RuntimeException("HttpAuthenticationMechanism '%s' requires one or more IdentityProviders supporting at least one\nof the following credentials types: %s.\nPlease refer to the https://quarkus.io/guides/security-identity-providers for more information.\n".formatted(mechanism.getClass().getName(), mechanism.getCredentialTypes()));
        }
        if (mechanisms.isEmpty()) {
            this.mechanisms = new HttpAuthenticationMechanism[]{new NoAuthenticationMechanism()};
        } else {
            mechanisms.sort(new Comparator<HttpAuthenticationMechanism>(){

                @Override
                public int compare(HttpAuthenticationMechanism mech1, HttpAuthenticationMechanism mech2) {
                    return Integer.compare(mech2.getPriority(), mech1.getPriority());
                }
            });
            this.mechanisms = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
        }
    }

    public IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        AbstractPathMatchingHttpSecurityPolicy pathMatchingPolicy = (AbstractPathMatchingHttpSecurityPolicy)routingContext.get(AbstractPathMatchingHttpSecurityPolicy.class.getName());
        final String pathSpecificMechanism = pathMatchingPolicy != null ? pathMatchingPolicy.getAuthMechanismName(routingContext) : null;
        Uni<HttpAuthenticationMechanism> matchingMechUni = this.findBestCandidateMechanism(routingContext, pathSpecificMechanism);
        Uni result = matchingMechUni == null ? this.createSecurityIdentity(routingContext) : matchingMechUni.onItem().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpAuthenticationMechanism mech) {
                if (mech != null) {
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
                if (pathSpecificMechanism != null) {
                    return Uni.createFrom().optional(Optional.empty());
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext);
            }
        });
        if (this.securityEventHelper.fireEventOnFailure()) {
            result = result.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    HttpAuthenticator.this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthenticationFailureEvent(throwable, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        if (this.securityEventHelper.fireEventOnSuccess()) {
            result = result.onItem().ifNotNull().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    HttpAuthenticator.this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthenticationSuccessEvent(securityIdentity, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        return result;
    }

    private Uni<SecurityIdentity> createSecurityIdentity(final RoutingContext routingContext) {
        Uni result = this.mechanisms[0].authenticate(routingContext, this.identityProviderManager);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(SecurityIdentity data) {
                    if (data != null) {
                        return Uni.createFrom().item((Object)data);
                    }
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
            });
        }
        return result;
    }

    public Uni<Boolean> sendChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (!routingContext.request().isEnded()) {
            routingContext.request().resume();
        }
        Uni result = null;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            result = matchingMech.sendChallenge(routingContext);
        }
        if (result == null) {
            result = this.mechanisms[0].sendChallenge(routingContext);
            for (int i = 1; i < this.mechanisms.length; ++i) {
                final HttpAuthenticationMechanism mech = this.mechanisms[i];
                result = result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

                    @Override
                    public Uni<? extends Boolean> apply(Boolean authDone) {
                        if (authDone.booleanValue()) {
                            return Uni.createFrom().item((Object)authDone);
                        }
                        return mech.sendChallenge(routingContext);
                    }
                });
            }
        }
        return result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(Boolean authDone) {
                if (!authDone.booleanValue()) {
                    log.debug((Object)"Authentication has not been done, returning HTTP status 401");
                    routingContext.response().setStatusCode(401);
                    routingContext.response().end();
                }
                return Uni.createFrom().item((Object)authDone);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            return matchingMech.getChallenge(routingContext);
        }
        Uni result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni((Function)new Function<ChallengeData, Uni<? extends ChallengeData>>(){

                @Override
                public Uni<? extends ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return Uni.createFrom().item((Object)data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    private Uni<HttpAuthenticationMechanism> findBestCandidateMechanism(final RoutingContext routingContext, final String pathSpecificMechanism) {
        Uni result = null;
        if (pathSpecificMechanism != null) {
            result = this.getPathSpecificMechanism(0, routingContext, pathSpecificMechanism);
            int i = 1;
            while (i < this.mechanisms.length) {
                final int mechIndex = i++;
                result = result.onItem().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends HttpAuthenticationMechanism>>(){

                    @Override
                    public Uni<? extends HttpAuthenticationMechanism> apply(HttpAuthenticationMechanism mech) {
                        if (mech != null) {
                            return Uni.createFrom().item((Object)mech);
                        }
                        return HttpAuthenticator.this.getPathSpecificMechanism(mechIndex, routingContext, pathSpecificMechanism);
                    }
                });
            }
        }
        return result;
    }

    private Uni<HttpAuthenticationMechanism> getPathSpecificMechanism(final int index, final RoutingContext routingContext, final String pathSpecificMechanism) {
        return HttpAuthenticator.getCredentialTransport(this.mechanisms[index], routingContext).onItem().transform((Function)new Function<HttpCredentialTransport, HttpAuthenticationMechanism>(){

            @Override
            public HttpAuthenticationMechanism apply(HttpCredentialTransport t) {
                if (t != null && t.getAuthenticationScheme().equalsIgnoreCase(pathSpecificMechanism)) {
                    routingContext.put(HttpAuthenticationMechanism.class.getName(), (Object)HttpAuthenticator.this.mechanisms[index]);
                    return HttpAuthenticator.this.mechanisms[index];
                }
                return null;
            }
        });
    }

    private static Uni<HttpCredentialTransport> getCredentialTransport(HttpAuthenticationMechanism mechanism, RoutingContext routingContext) {
        try {
            return mechanism.getCredentialTransport(routingContext);
        }
        catch (UnsupportedOperationException ex) {
            return Uni.createFrom().item((Object)mechanism.getCredentialTransport());
        }
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().optional(Optional.empty());
        }

        @Override
        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return Uni.createFrom().item((Object)challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }

        @Override
        public HttpCredentialTransport getCredentialTransport() {
            return null;
        }
    }
}

