/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.runtime.WebSocketConnectionImpl;
import io.quarkus.websockets.next.runtime.spi.security.WebSocketIdentityUpdateRequest;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public final class SecuritySupport {
    public static final String QUARKUS_IDENTITY_EXPIRE_TIME = "quarkus.identity.expire-time";
    private static final Logger LOG = Logger.getLogger(SecuritySupport.class);
    static final SecuritySupport NOOP = new SecuritySupport(null, null, null, null);
    private final Instance<CurrentIdentityAssociation> currentIdentity;
    private final ManagedContext requestContext;
    private final RoutingContext routingContext;
    private volatile SecurityIdentity identity;
    private volatile Runnable onClose;

    SecuritySupport(Instance<CurrentIdentityAssociation> currentIdentity, SecurityIdentity identity, WebSocketConnectionImpl connection, RoutingContext routingContext) {
        this.currentIdentity = currentIdentity;
        if (this.currentIdentity != null) {
            this.identity = Objects.requireNonNull(identity);
            this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(routingContext.vertx(), connection, this.identity);
        } else {
            this.identity = null;
            this.onClose = null;
        }
        this.requestContext = Arc.container().requestContext();
        this.routingContext = routingContext;
    }

    void start() {
        if (this.currentIdentity != null && this.requestContext.isActive()) {
            CurrentIdentityAssociation current = (CurrentIdentityAssociation)this.currentIdentity.get();
            current.setIdentity(this.identity);
        }
    }

    void onClose() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    CompletionStage<SecurityIdentity> updateSecurityIdentity(String accessToken, WebSocketConnectionImpl connection, IdentityProviderManager identityProviderManager) {
        WebSocketIdentityUpdateRequest authenticationRequest = new WebSocketIdentityUpdateRequest(new TokenCredential(accessToken, "bearer"), this.identity);
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)authenticationRequest, (RoutingContext)this.routingContext)).onItem().ifNull().failWith(AuthenticationFailedException::new).invoke(newIdentity -> this.updateSecurityIdentity((SecurityIdentity)newIdentity, connection)).onFailure().invoke(throwable -> LOG.debug((Object)("Failed to update SecurityIdentity attached to the WebSocket connection with id " + connection.id()), throwable)).convert().toCompletionStage();
    }

    private synchronized void updateSecurityIdentity(SecurityIdentity updatedIdentity, WebSocketConnectionImpl connection) {
        String currentPrincipalName;
        String previousPrincipalName;
        if (connection.isClosed()) {
            return;
        }
        if (updatedIdentity.isAnonymous()) {
            throw new AuthenticationFailedException("Updated SecurityIdentity is anonymous");
        }
        if (LOG.isDebugEnabled()) {
            Long expireAt = (Long)updatedIdentity.getAttribute(QUARKUS_IDENTITY_EXPIRE_TIME);
            String path = this.routingContext.normalizedPath();
            String principalName = updatedIdentity.getPrincipal().getName();
            LOG.debugf("Updated 'SecurityIdentity' with principal name '%s' used by WebSocket connection '%s' and path '%s', the new SecurityIdentity expires at '%d'", new Object[]{principalName, connection.id(), path, expireAt});
        }
        if (!(previousPrincipalName = this.identity.getPrincipal().getName()).equals(currentPrincipalName = updatedIdentity.getPrincipal().getName())) {
            throw new WebSocketServerException("New SecurityIdentity principal name '%s' is different than previous principal name '%s'. SecurityIdentity update is aborted".formatted(currentPrincipalName, previousPrincipalName));
        }
        this.onClose();
        this.identity = updatedIdentity;
        this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(this.routingContext.vertx(), connection, updatedIdentity);
        if (connection.isClosed()) {
            this.onClose();
        } else {
            this.start();
        }
    }

    private static Runnable closeConnectionWhenIdentityExpired(Vertx vertx, WebSocketConnectionImpl connection, SecurityIdentity identity) {
        Object object = identity.getAttribute(QUARKUS_IDENTITY_EXPIRE_TIME);
        if (object instanceof Long) {
            Long expireAt = (Long)object;
            long timerId = vertx.setTimer(TimeUnit.SECONDS.toMillis(expireAt) - System.currentTimeMillis(), ignored -> connection.close(new CloseReason(1008, "Authentication expired")).subscribe().with(v -> LOG.tracef("Closed connection due to expired authentication: %s", (Object)connection), e -> LOG.errorf("Unable to close connection [%s] after authentication expired due to unhandled failure: %s", (Object)connection, e)));
            return () -> vertx.cancelTimer(timerId);
        }
        return null;
    }
}

