/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;

public final class SecurityHttpUpgradeCheck
implements HttpUpgradeCheck {
    public static final int BEAN_PRIORITY = 2147483547;
    public static final String SECURED_ENDPOINT_ID_KEY = SecurityHttpUpgradeCheck.class.getName() + ".ENDPOINT_ID";
    public static final String HTTP_REQUEST_KEY = SecurityHttpUpgradeCheck.class.getName() + ".HTTP_REQUEST";
    private final String redirectUrl;
    private final Map<String, SecurityCheck> endpointToCheck;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;

    SecurityHttpUpgradeCheck(String redirectUrl, Map<String, SecurityCheck> endpointToCheck, SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper) {
        this.redirectUrl = redirectUrl;
        this.endpointToCheck = Map.copyOf(endpointToCheck);
        this.securityEventHelper = securityEventHelper;
    }

    @Override
    public Uni<HttpUpgradeCheck.CheckResult> perform(HttpUpgradeCheck.HttpUpgradeContext context) {
        SecurityCheck securityCheck = this.endpointToCheck.get(context.endpointId());
        return context.securityIdentity().chain(identity -> securityCheck.nonBlockingApply(identity, (MethodDescription)null, null).replaceWith(() -> this.permitUpgrade((SecurityIdentity)identity, securityCheck, context)).onFailure(SecurityException.class).recoverWithItem(t -> this.rejectUpgrade((Throwable)t, (SecurityIdentity)identity, securityCheck, context)));
    }

    @Override
    public boolean appliesTo(String endpointId) {
        return this.endpointToCheck.containsKey(endpointId);
    }

    private HttpUpgradeCheck.CheckResult permitUpgrade(SecurityIdentity identity, SecurityCheck securityCheck, HttpUpgradeCheck.HttpUpgradeContext context) {
        if (this.securityEventHelper.fireEventOnSuccess()) {
            String authorizationContext = securityCheck.getClass().getName();
            AuthorizationSuccessEvent successEvent = new AuthorizationSuccessEvent(identity, authorizationContext, Map.of(SECURED_ENDPOINT_ID_KEY, context.endpointId(), HTTP_REQUEST_KEY, context.httpRequest()));
            this.securityEventHelper.fireSuccessEvent((SecurityEvent)successEvent);
        }
        return HttpUpgradeCheck.CheckResult.permitUpgradeSync();
    }

    private HttpUpgradeCheck.CheckResult rejectUpgrade(Throwable throwable, SecurityIdentity identity, SecurityCheck securityCheck, HttpUpgradeCheck.HttpUpgradeContext context) {
        if (this.securityEventHelper.fireEventOnFailure()) {
            String authorizationContext = securityCheck.getClass().getName();
            AuthorizationFailureEvent failureEvent = new AuthorizationFailureEvent(identity, throwable, authorizationContext, Map.of(SECURED_ENDPOINT_ID_KEY, context.endpointId(), HTTP_REQUEST_KEY, context.httpRequest()));
            this.securityEventHelper.fireFailureEvent((SecurityEvent)failureEvent);
        }
        if (this.redirectUrl != null) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(302, Map.of(HttpHeaderNames.LOCATION.toString(), List.of(this.redirectUrl), HttpHeaderNames.CACHE_CONTROL.toString(), List.of("no-store")));
        }
        if (throwable instanceof ForbiddenException) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(403);
        }
        return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(401);
    }
}

