/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.spi.telemetry.EndpointKind;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketTracesInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.telemetry.TracesConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TracesForwardingWebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TracesBuilderCustomizer
implements Consumer<WebSocketTelemetryProviderBuilder> {
    @Inject
    WebSocketsServerRuntimeConfig serverRuntimeConfig;
    @Inject
    WebSocketsClientRuntimeConfig clientRuntimeConfig;
    @Inject
    Instance<WebSocketTracesInterceptor> tracesInterceptorInstance;

    @Override
    public void accept(WebSocketTelemetryProviderBuilder builder) {
        if (!this.tracesInterceptorInstance.isResolvable()) {
            return;
        }
        boolean serverTracesEnabled = this.serverRuntimeConfig.telemetry().tracesEnabled();
        boolean clientTracesEnabled = this.clientRuntimeConfig.telemetry().tracesEnabled();
        if (serverTracesEnabled || clientTracesEnabled) {
            WebSocketTracesInterceptor tracesInterceptor = (WebSocketTracesInterceptor)this.tracesInterceptorInstance.get();
            if (serverTracesEnabled) {
                TracesBuilderCustomizer.addServerTracesSupport(builder, tracesInterceptor);
            }
            if (clientTracesEnabled) {
                TracesBuilderCustomizer.addClientTracesSupport(builder, tracesInterceptor);
            }
        }
    }

    private static void addServerTracesSupport(WebSocketTelemetryProviderBuilder builder, final WebSocketTracesInterceptor tracesInterceptor) {
        builder.serverEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new TracesForwardingWebSocketEndpoint(ctx.endpoint(), tracesInterceptor, ctx.forServer());
            }
        });
        builder.pathToServerConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new TracesConnectionInterceptor(tracesInterceptor, path, EndpointKind.SERVER);
            }
        });
    }

    private static void addClientTracesSupport(WebSocketTelemetryProviderBuilder builder, final WebSocketTracesInterceptor tracesInterceptor) {
        builder.clientEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new TracesForwardingWebSocketEndpoint(ctx.endpoint(), tracesInterceptor, ctx.forClient());
            }
        });
        builder.pathToClientConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new TracesConnectionInterceptor(tracesInterceptor, path, EndpointKind.CLIENT);
            }
        });
    }
}

