/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.runtime.WebSocketConnectionImpl;
import io.quarkus.websockets.next.runtime.spi.security.WebSocketIdentityUpdateRequest;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public final class SecuritySupport {
    public static final String QUARKUS_IDENTITY_EXPIRE_TIME = "quarkus.identity.expire-time";
    private static final Logger LOG = Logger.getLogger(SecuritySupport.class);
    static final SecuritySupport NOOP = new SecuritySupport(null, null, null);
    private final RoutingContext routingContext;
    private final WebSocketConnectionImpl connection;
    private volatile SecurityIdentity identity;
    private volatile Runnable onClose;

    SecuritySupport(SecurityIdentity identity, WebSocketConnectionImpl connection, RoutingContext routingContext) {
        this.identity = identity;
        this.connection = connection;
        this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(routingContext, connection, this.identity);
        this.routingContext = routingContext;
    }

    void onClose() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    SecurityIdentity getIdentity() {
        return this.identity;
    }

    Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.routingContext == null) {
            return null;
        }
        Uni deferredIdentity = (Uni)this.routingContext.get("io.quarkus.vertx.http.deferred-identity");
        if (deferredIdentity == null) {
            return null;
        }
        return deferredIdentity.map(resolvedIdentity -> {
            if (resolvedIdentity != null && !resolvedIdentity.isAnonymous()) {
                Object patt0$temp = resolvedIdentity.getAttribute(QUARKUS_IDENTITY_EXPIRE_TIME);
                if (patt0$temp instanceof Long) {
                    boolean isExpired;
                    Long expireAt = (Long)patt0$temp;
                    boolean bl = isExpired = TimeUnit.SECONDS.toMillis(expireAt) - System.currentTimeMillis() <= 0L;
                    if (isExpired) {
                        this.routingContext.remove("io.quarkus.vertx.http.deferred-identity");
                        return null;
                    }
                }
                this.identity = resolvedIdentity;
                this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(this.routingContext, this.connection, resolvedIdentity);
            }
            return resolvedIdentity;
        });
    }

    CompletionStage<SecurityIdentity> updateSecurityIdentity(String accessToken, WebSocketConnectionImpl connection, IdentityProviderManager identityProviderManager) {
        WebSocketIdentityUpdateRequest authenticationRequest = new WebSocketIdentityUpdateRequest(new TokenCredential(accessToken, "bearer"), this.identity);
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)authenticationRequest, (RoutingContext)this.routingContext)).onItem().ifNull().failWith(AuthenticationFailedException::new).invoke(newIdentity -> this.updateSecurityIdentity((SecurityIdentity)newIdentity, connection)).onFailure().invoke(throwable -> LOG.debug((Object)("Failed to update SecurityIdentity attached to the WebSocket connection with id " + connection.id()), throwable)).convert().toCompletionStage();
    }

    private synchronized void updateSecurityIdentity(SecurityIdentity updatedIdentity, WebSocketConnectionImpl connection) {
        String currentPrincipalName;
        String previousPrincipalName;
        if (connection.isClosed()) {
            return;
        }
        if (updatedIdentity.isAnonymous()) {
            throw new AuthenticationFailedException("Updated SecurityIdentity is anonymous");
        }
        if (LOG.isDebugEnabled()) {
            Long expireAt = (Long)updatedIdentity.getAttribute(QUARKUS_IDENTITY_EXPIRE_TIME);
            String path = this.routingContext.normalizedPath();
            String principalName = updatedIdentity.getPrincipal().getName();
            LOG.debugf("Updated 'SecurityIdentity' with principal name '%s' used by WebSocket connection '%s' and path '%s', the new SecurityIdentity expires at '%d'", new Object[]{principalName, connection.id(), path, expireAt});
        }
        if (!(previousPrincipalName = this.identity.getPrincipal().getName()).equals(currentPrincipalName = updatedIdentity.getPrincipal().getName())) {
            throw new WebSocketServerException("New SecurityIdentity principal name '%s' is different than previous principal name '%s'. SecurityIdentity update is aborted".formatted(currentPrincipalName, previousPrincipalName));
        }
        this.onClose();
        this.identity = updatedIdentity;
        this.routingContext.setUser((User)new QuarkusHttpUser(updatedIdentity));
        this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(this.routingContext, connection, updatedIdentity);
        if (connection.isClosed()) {
            this.onClose();
        }
    }

    private static Runnable closeConnectionWhenIdentityExpired(RoutingContext routingContext, WebSocketConnectionImpl connection, SecurityIdentity identity) {
        Object object;
        if (identity != null && (object = identity.getAttribute(QUARKUS_IDENTITY_EXPIRE_TIME)) instanceof Long) {
            Long expireAt = (Long)object;
            Vertx vertx = routingContext.vertx();
            long timerId = vertx.setTimer(TimeUnit.SECONDS.toMillis(expireAt) - System.currentTimeMillis(), ignored -> connection.close(new CloseReason(1008, "Authentication expired")).subscribe().with(v -> LOG.tracef("Closed connection due to expired authentication: %s", (Object)connection), e -> LOG.errorf("Unable to close connection [%s] after authentication expired due to unhandled failure: %s", (Object)connection, e)));
            return () -> vertx.cancelTimer(timerId);
        }
        return null;
    }
}

