/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.ServiceInstance;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Priority(value=1000)
@Provider
public class StorkClientRequestFilter
implements ResteasyReactiveClientRequestFilter {
    private static final Logger log = Logger.getLogger(StorkClientRequestFilter.class);

    @Override
    public void filter(ResteasyReactiveClientRequestContext requestContext) {
        URI uri = requestContext.getUri();
        if (uri != null && uri.getScheme() != null && uri.getScheme().startsWith("stork")) {
            Uni serviceInstance;
            String serviceName = uri.getHost();
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid REST Client URL used: '" + uri + "'");
            }
            requestContext.suspend();
            boolean measureTime = this.shouldMeasureTime(requestContext.getResponseType());
            try {
                serviceInstance = Stork.getInstance().getService(serviceName).selectInstanceAndRecordStart(measureTime).log();
            }
            catch (Throwable e) {
                log.error((Object)("Error selecting service instance for serviceName: " + serviceName), e);
                requestContext.resume(e);
                return;
            }
            serviceInstance.subscribe().with(instance -> {
                boolean isHttps = instance.isSecure() || "storks".equals(uri.getScheme());
                String scheme = isHttps ? "https" : "http";
                try {
                    String host = instance.getHost() == null ? "localhost" : instance.getHost();
                    int port = instance.getPort();
                    if (instance.getPort() == 0) {
                        port = isHttps ? 433 : 80;
                    }
                    URI newUri = new URI(scheme, uri.getUserInfo(), host, port, uri.getPath(), uri.getQuery(), uri.getFragment());
                    requestContext.setUri(newUri);
                    if (measureTime && instance.gatherStatistics()) {
                        requestContext.setCallStatsCollector((ServiceInstance)instance);
                    }
                    requestContext.resume();
                }
                catch (URISyntaxException e) {
                    requestContext.resume(new IllegalArgumentException("Invalid URI", e));
                }
            }, requestContext::resume);
        }
    }

    private boolean shouldMeasureTime(GenericType<?> responseType) {
        return !Multi.class.equals((Object)responseType.getRawType());
    }
}

