/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.concurrent.atomic.AtomicLong;

class RequestTrackingPipe<T>
implements Pipe<T> {
    private final long maxInFlightReads;
    private final Promise<Void> result;
    private final ReadStream<T> src;
    private boolean endOnSuccess = true;
    private boolean endOnFailure = true;
    private WriteStream<T> dst;
    private boolean manuallyPaused = false;
    private final AtomicLong inFlightReads = new AtomicLong(0L);

    public RequestTrackingPipe(ReadStream<T> src, long maxInFlightReads) {
        this.src = src;
        this.maxInFlightReads = maxInFlightReads;
        this.result = Promise.promise();
        src.endHandler(arg_0 -> this.result.tryComplete(arg_0));
        src.exceptionHandler(arg_0 -> this.result.tryFail(arg_0));
    }

    public synchronized Pipe<T> endOnFailure(boolean end) {
        this.endOnFailure = end;
        return this;
    }

    public synchronized Pipe<T> endOnSuccess(boolean end) {
        this.endOnSuccess = end;
        return this;
    }

    public synchronized Pipe<T> endOnComplete(boolean end) {
        this.endOnSuccess = end;
        this.endOnFailure = end;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWriteResult(AsyncResult<Void> ack) {
        long currentInFlightReads = this.inFlightReads.decrementAndGet();
        if (currentInFlightReads <= this.maxInFlightReads / 2L) {
            RequestTrackingPipe requestTrackingPipe = this;
            synchronized (requestTrackingPipe) {
                if (this.manuallyPaused) {
                    this.manuallyPaused = false;
                    this.src.resume();
                }
            }
        }
        if (ack.failed()) {
            this.result.tryFail((Throwable)((Object)new WriteException(ack.cause())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void to(WriteStream<T> ws, Handler<AsyncResult<Void>> completionHandler) {
        if (ws == null) {
            throw new NullPointerException();
        }
        RequestTrackingPipe requestTrackingPipe = this;
        synchronized (requestTrackingPipe) {
            if (this.dst != null) {
                throw new IllegalStateException();
            }
            this.dst = ws;
            boolean endOnSuccess = this.endOnSuccess;
            boolean endOnFailure = this.endOnFailure;
        }
        Handler drainHandler = v -> this.src.resume();
        this.src.handler(item -> {
            ws.write(item, this::handleWriteResult);
            long currentInFlightReads = this.inFlightReads.incrementAndGet();
            if (ws.writeQueueFull()) {
                this.src.pause();
                ws.drainHandler(drainHandler);
            } else if (currentInFlightReads > this.maxInFlightReads) {
                RequestTrackingPipe requestTrackingPipe = this;
                synchronized (requestTrackingPipe) {
                    this.src.pause();
                    this.manuallyPaused = true;
                }
            }
        });
        this.src.resume();
        this.result.future().onComplete(ar -> {
            try {
                this.src.handler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.exceptionHandler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.endHandler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ar.succeeded()) {
                this.handleSuccess(completionHandler);
            } else {
                Throwable err = ar.cause();
                if (err instanceof WriteException) {
                    this.src.resume();
                    err = err.getCause();
                }
                this.handleFailure(err, completionHandler);
            }
        });
    }

    private void handleSuccess(Handler<AsyncResult<Void>> completionHandler) {
        if (this.endOnSuccess) {
            this.dst.end(completionHandler);
        } else {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    private void handleFailure(Throwable cause, Handler<AsyncResult<Void>> completionHandler) {
        Future res = Future.failedFuture((Throwable)cause);
        if (this.endOnFailure) {
            this.dst.end(ignore -> completionHandler.handle((Object)res));
        } else {
            completionHandler.handle((Object)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RequestTrackingPipe requestTrackingPipe = this;
        synchronized (requestTrackingPipe) {
            this.src.exceptionHandler(null);
            this.src.handler(null);
            if (this.dst != null) {
                this.dst.drainHandler(null);
                this.dst.exceptionHandler(null);
            }
        }
        VertxException err = new VertxException("Pipe closed", true);
        if (this.result.tryFail((Throwable)err)) {
            this.src.resume();
        }
    }

    private static class WriteException
    extends VertxException {
        private WriteException(Throwable cause) {
            super(cause, true);
        }
    }
}

