/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Context;
import io.vertx.core.http.HttpClient;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestHeaders;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.InvocationImpl;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.jboss.resteasy.reactive.client.impl.RequestSpec;
import org.jboss.resteasy.reactive.client.impl.UniInvoker;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class InvocationBuilderImpl
implements Invocation.Builder {
    private static final long DEFAULT_READ_TIMEOUT = 30000L;
    final URI uri;
    final HttpClient httpClient;
    final WebTargetImpl target;
    final RequestSpec requestSpec;
    final Map<String, Object> properties = new HashMap<String, Object>();
    final ConfigurationImpl configuration;
    final ClientImpl restClient;
    final HandlerChain handlerChain;
    final ThreadSetupAction requestContext;
    final long readTimeoutMs;

    public InvocationBuilderImpl(URI uri, ClientImpl restClient, HttpClient httpClient, WebTargetImpl target, ConfigurationImpl configuration, HandlerChain handlerChain, ThreadSetupAction requestContext) {
        this.uri = uri;
        this.restClient = restClient;
        this.httpClient = httpClient;
        this.target = target;
        this.requestSpec = new RequestSpec(configuration);
        this.configuration = configuration;
        this.handlerChain = handlerChain;
        this.requestContext = requestContext;
        Object readTimeoutMs = configuration.getProperty("io.quarkus.rest.client.read-timeout");
        this.readTimeoutMs = readTimeoutMs == null ? 30000L : (Long)readTimeoutMs;
    }

    public Invocation build(String method) {
        return new InvocationImpl(method, this.async(), null);
    }

    public Invocation build(String method, Entity<?> entity) {
        return new InvocationImpl(method, this.async(), entity);
    }

    public Invocation buildGet() {
        return this.build("GET");
    }

    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    public AsyncInvokerImpl async() {
        return new AsyncInvokerImpl(this.restClient, this.httpClient, this.uri, this.requestSpec, this.configuration, this.properties, this.handlerChain, this.requestContext);
    }

    public Invocation.Builder accept(String ... mediaTypes) {
        this.requestSpec.headers.accept(mediaTypes);
        return this;
    }

    public Invocation.Builder accept(MediaType ... mediaTypes) {
        this.requestSpec.headers.accept(mediaTypes);
        return this;
    }

    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.requestSpec.headers.acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptLanguage(String ... locales) {
        this.requestSpec.headers.acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.requestSpec.headers.acceptEncoding(encodings);
        return this;
    }

    public Invocation.Builder cookie(Cookie cookie) {
        this.requestSpec.headers.cookie(cookie);
        return this;
    }

    public Invocation.Builder cookie(String name, String value) {
        this.requestSpec.headers.cookie(new Cookie(name, value));
        return this;
    }

    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.requestSpec.headers.cacheControl(cacheControl);
        return this;
    }

    public Invocation.Builder header(String name, Object value) {
        this.requestSpec.headers.header(name, value);
        return this;
    }

    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.requestSpec.headers.setHeaders(headers);
        return this;
    }

    public Invocation.Builder property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public CompletionStageRxInvoker rx() {
        return new AsyncInvokerImpl(this.restClient, this.httpClient, this.uri, this.requestSpec, this.configuration, this.properties, this.handlerChain, this.requestContext);
    }

    public <T extends RxInvoker> T rx(Class<T> clazz) {
        if (clazz == MultiInvoker.class) {
            return (T)new MultiInvoker(this);
        }
        if (clazz == UniInvoker.class) {
            return (T)new UniInvoker(this);
        }
        RxInvokerProvider invokerProvider = this.requestSpec.configuration.getRxInvokerProvider(clazz);
        if (invokerProvider != null) {
            return (T)invokerProvider.getRxInvoker((SyncInvoker)this, null);
        }
        return null;
    }

    public Response get() {
        return (Response)this.unwrap((CompletableFuture)this.async().get());
    }

    private <T> T unwrap(CompletableFuture<T> c) {
        if (Context.isOnEventLoopThread()) {
            throw new BlockingNotAllowedException();
        }
        try {
            return c.get();
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProcessingException) {
                throw (ProcessingException)e.getCause();
            }
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new ProcessingException(e.getCause().getMessage(), e.getCause());
        }
    }

    public <T> T get(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().get((Class)responseType));
    }

    public <T> T get(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().get((GenericType)responseType));
    }

    public Response put(Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().put((Entity)entity));
    }

    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().put((Entity)entity, (Class)responseType));
    }

    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().put((Entity)entity, (GenericType)responseType));
    }

    public Response post(Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().post((Entity)entity));
    }

    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().post((Entity)entity, (Class)responseType));
    }

    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().post((Entity)entity, (GenericType)responseType));
    }

    public Response delete() {
        return (Response)this.unwrap((CompletableFuture)this.async().delete());
    }

    public <T> T delete(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().delete((Class)responseType));
    }

    public <T> T delete(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().delete((GenericType)responseType));
    }

    public Response head() {
        return (Response)this.unwrap((CompletableFuture)this.async().head());
    }

    public Response options() {
        return (Response)this.unwrap((CompletableFuture)this.async().options());
    }

    public <T> T options(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().options((Class)responseType));
    }

    public <T> T options(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().options((GenericType)responseType));
    }

    public Response trace() {
        return (Response)this.unwrap((CompletableFuture)this.async().trace());
    }

    public <T> T trace(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().trace((Class)responseType));
    }

    public <T> T trace(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().trace((GenericType)responseType));
    }

    public Response method(String name) {
        return (Response)this.unwrap((CompletableFuture)this.async().method(name));
    }

    public <T> T method(String name, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Class)responseType));
    }

    public <T> T method(String name, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (GenericType)responseType));
    }

    public Response method(String name, Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().method(name, (Entity)entity));
    }

    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Entity)entity, (Class)responseType));
    }

    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Entity)entity, (GenericType)responseType));
    }

    public WebTargetImpl getTarget() {
        return this.target;
    }

    public void setChunked(boolean chunked) {
        this.requestSpec.chunked = chunked;
    }

    public boolean getChunked() {
        return this.requestSpec.chunked;
    }

    public ClientRequestHeaders getHeaders() {
        return this.requestSpec.headers;
    }
}

