/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.client.handlers.VertxClientInputStream;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;

public class ClientResponseImpl
extends ResponseImpl {
    RestClientRequestContext restClientRequestContext;

    public boolean bufferEntity() {
        InputStream entityStream = this.getEntityStream();
        if (entityStream == null) {
            return false;
        }
        if (VertxClientInputStream.class.equals(entityStream.getClass()) && !BlockingOperationSupport.isBlockingAllowed()) {
            return true;
        }
        return super.bufferEntity();
    }

    protected <T> T readEntity(Class<T> entityType, Type genericType, Annotation[] annotations) {
        if (this.entity != null && entityType.isInstance(this.entity)) {
            return (T)this.entity;
        }
        this.checkClosed();
        InputStream entityStream = this.getEntityStream();
        if (entityStream == null) {
            entityStream = new EmptyInputStream();
        }
        try {
            if (this.buffered) {
                entityStream.reset();
            }
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        if (InputStream.class.isAssignableFrom(entityType)) {
            return (T)entityStream;
        }
        MediaType mediaType = this.getMediaType();
        try {
            this.entity = ClientSerialisers.invokeClientReader(annotations, entityType, genericType, mediaType, this.restClientRequestContext.properties, this.restClientRequestContext, this.getStringHeaders(), this.restClientRequestContext.getRestClient().getClientContext().getSerialisers(), entityStream, this.restClientRequestContext.getReaderInterceptors(), this.restClientRequestContext.configuration);
            this.consumed = true;
            this.close();
            return (T)this.entity;
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public String getHttpVersion() {
        return this.restClientRequestContext.getVertxClientResponse().version().toString();
    }

    public StackTraceElement[] getCallerStackTrace() {
        return this.restClientRequestContext.getCallerStackTrace();
    }
}

