/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.handlers.ClientCaptureCurrentContextRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientErrorHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientRequestFilterRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseCompleteRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseFilterRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSendRequestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSetResponseEntityRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSwitchToRequestContextRestHandler;
import org.jboss.resteasy.reactive.client.handlers.PreResponseFilterHandler;
import org.jboss.resteasy.reactive.client.impl.PreservesThreadClientResponseFilter;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

class HandlerChain {
    private static final ClientRestHandler[] EMPTY_REST_HANDLERS = new ClientRestHandler[0];
    private final ClientRestHandler clientCaptureCurrentContextRestHandler;
    private final ClientRestHandler clientSwitchToRequestContextRestHandler;
    private final ClientRestHandler clientSendHandler;
    private final ClientRestHandler clientSetResponseEntityRestHandler;
    private final ClientRestHandler clientResponseCompleteRestHandler;
    private final ClientRestHandler clientErrorHandler;
    private ClientRestHandler preClientSendHandler = null;

    public HandlerChain(HttpClientOptions httpClientOptions, boolean captureStacktrace, boolean followRedirects, LoggingScope loggingScope, Map<Class<?>, MultipartResponseData> multipartData, ClientLogger clientLogger, List<Consumer<HttpClientRequest>> clientRequestCustomizers) {
        this.clientCaptureCurrentContextRestHandler = new ClientCaptureCurrentContextRestHandler(captureStacktrace);
        this.clientSwitchToRequestContextRestHandler = new ClientSwitchToRequestContextRestHandler();
        this.clientSendHandler = new ClientSendRequestHandler(httpClientOptions, followRedirects, loggingScope, clientLogger, multipartData, clientRequestCustomizers);
        this.clientSetResponseEntityRestHandler = new ClientSetResponseEntityRestHandler();
        this.clientResponseCompleteRestHandler = new ClientResponseCompleteRestHandler();
        this.clientErrorHandler = new ClientErrorHandler(loggingScope);
    }

    private HandlerChain(ClientRestHandler clientCaptureCurrentContextRestHandler, ClientRestHandler clientSwitchToRequestContextRestHandler, ClientRestHandler clientSendHandler, ClientRestHandler clientSetResponseEntityRestHandler, ClientRestHandler clientResponseCompleteRestHandler, ClientRestHandler clientErrorHandler) {
        this.clientCaptureCurrentContextRestHandler = clientCaptureCurrentContextRestHandler;
        this.clientSwitchToRequestContextRestHandler = clientSwitchToRequestContextRestHandler;
        this.clientSendHandler = clientSendHandler;
        this.clientSetResponseEntityRestHandler = clientSetResponseEntityRestHandler;
        this.clientResponseCompleteRestHandler = clientResponseCompleteRestHandler;
        this.clientErrorHandler = clientErrorHandler;
    }

    private HandlerChain newInstance() {
        return new HandlerChain(this.clientCaptureCurrentContextRestHandler, this.clientSwitchToRequestContextRestHandler, this.clientSendHandler, this.clientSetResponseEntityRestHandler, this.clientResponseCompleteRestHandler, this.clientErrorHandler);
    }

    HandlerChain setPreClientSendHandler(ClientRestHandler preClientSendHandler) {
        HandlerChain newHandlerChain = this.newInstance();
        newHandlerChain.preClientSendHandler = preClientSendHandler;
        return newHandlerChain;
    }

    ClientRestHandler[] createHandlerChain(ConfigurationImpl configuration) {
        int i;
        List requestFilters = configuration.getRequestFilters();
        List responseFilters = configuration.getResponseFilters();
        if (requestFilters.isEmpty() && responseFilters.isEmpty()) {
            return new ClientRestHandler[]{this.clientCaptureCurrentContextRestHandler, this.clientSwitchToRequestContextRestHandler, this.clientSendHandler, this.clientSetResponseEntityRestHandler, this.clientResponseCompleteRestHandler};
        }
        ArrayList<ClientRestHandler> result = new ArrayList<ClientRestHandler>((this.preClientSendHandler != null ? 4 : 3) + requestFilters.size() + responseFilters.size());
        if (this.preClientSendHandler != null) {
            result.add(this.preClientSendHandler);
        }
        result.add(this.clientCaptureCurrentContextRestHandler);
        for (i = 0; i < requestFilters.size(); ++i) {
            result.add(new ClientRequestFilterRestHandler((ClientRequestFilter)requestFilters.get(i)));
        }
        result.add(this.clientSwitchToRequestContextRestHandler);
        result.add(this.clientSendHandler);
        result.add(this.clientSetResponseEntityRestHandler);
        result.add(new PreResponseFilterHandler());
        for (i = 0; i < responseFilters.size(); ++i) {
            ClientResponseFilter filter = (ClientResponseFilter)responseFilters.get(i);
            result.add(new ClientResponseFilterRestHandler(filter, filter instanceof PreservesThreadClientResponseFilter));
        }
        result.add(this.clientResponseCompleteRestHandler);
        return result.toArray(EMPTY_REST_HANDLERS);
    }

    ClientRestHandler[] createAbortHandlerChain(ConfigurationImpl configuration) {
        List responseFilters = configuration.getResponseFilters();
        if (responseFilters.isEmpty()) {
            return this.createAbortHandlerChainWithoutResponseFilters();
        }
        ArrayList<ClientRestHandler> result = new ArrayList<ClientRestHandler>(1 + responseFilters.size());
        for (int i = 0; i < responseFilters.size(); ++i) {
            result.add(new ClientResponseFilterRestHandler((ClientResponseFilter)responseFilters.get(i), true));
        }
        result.add(this.clientErrorHandler);
        return result.toArray(EMPTY_REST_HANDLERS);
    }

    ClientRestHandler[] createAbortHandlerChainWithoutResponseFilters() {
        return new ClientRestHandler[]{this.clientErrorHandler};
    }
}

